#!/bin/bash
project=$1
config_server=$2
project_path=$3
ip=$4
time=`date +%Y_%m_%d_%H_%M_%S`

desc=`node $config_server/get_project_config.js  -name $project -attr desc`
port=`node $config_server/get_project_config.js  -name $project -attr port`
sh $config_server/show_info.sh $project 重新启动 $desc $ip
cd $project_path/$project
setup_path_temp=`find ./ -name "run.py"`
python_project_path=$project_path/$project${setup_path_temp/\.\//\/}

P_UUID=`ps -ef|grep port=$port |grep -v 'grep'|awk '{print $2}'`
if [[ "${P_UUID}" != "" ]];then
	echo "KILL $project PPID=${P_UUID}"
	kill -9 ${P_UUID}
	sleep 3
fi
mv $project_path/logs/${project}.log $project_path/logs/${project}.log.$time
echo "project:$project will be run under command:python $python_project_path --mode=beta --port=$port > /dev/null 2>&1 &"
python $python_project_path --mode=beta --port=$port > /dev/null 2>&1 &
sleep 5
grep "$project started OK" $project_path/logs/${project}.log
if [ $? != 0 ];then
	exit -1
fi
	
