#!/bin/bash

scriptname=$(basename $0)
lock="/var/run/${scriptname}"
pwd_path_0="/home/qa-deploy-utils"

exec 200>$lock

flock -n 200
if [ $? -ne 0 ];then
	_p=`ps aux  | grep $scriptname | grep -v grep | head -n 1 |awk '{print $2}'`
	echo "$scriptname 正在被其他人执行，进程号：$_p，预计时间一分钟，请稍后再试~"
	exit 1
fi

## The code:
pid=$$
echo $pid 1>&200

public_ip="q-gp.com"
pwd_path="/home/qa-deploy-utils/qa_shell_script"
config_server="$pwd_path/config_server"
ips=`cat $config_server/get_env_ip.sh`
counts=`echo $ips | awk '{print NF}'`

mkdir -p /home/sub_config_file_dont_rm
multis=`node $config_server/get_project_config.js  -type multi -attr port -attr2 true`

trap "exec 1000>&-;exec 1000<&-;exit 0" 2
tempfifo=$$.fifo
mkfifo /tmp/$tempfifo
exec 1000<>/tmp/$tempfifo
rm -rf /tmp/$tempfifo

for ((i=1; i<=3; i++))
do
	echo >&1000
done

echo "共要生成$counts个环境的配置文件"
echo "并发生成3个环境的配置文件，预计执行时间一分钟左右，负载最大时为3~"


for ip_last_num in ${ips[@]} 
do
	IP_host=`sh $pwd_path_0/get-ip.sh $ip_last_num`
	read -u1000
	{
		echo "`date +%T.%N` 开始生成 ${IP_host}"
		cd /home/sub_config_file_dont_rm
		#不能直接RM 整个文件，会造成mount失效
		mkdir -p ${IP_host}
		cd ${IP_host}
		rm -rf java
		rm -rf node
		rm -rf ui
		rm -rf python
		rm -rf public
		rm -rf nginx_conf.d
		rm -rf pem_file
		

		dir=`pwd`
		
		#java项目发布
		mkdir -p $dir/java
		mkdir -p $dir/public/java
		cp -rf /home/config_files/java/* $dir/java/
		cp -rf /home/config_files/java/* $dir/public/java/
		sed -i "s/target_host_name/${IP_host}/" $dir/java/*
		sed -i "s/target_host_name/${IP_host}/" $dir/public/java/*
		sed -i "s/target_mq_host_name/${IP_host}/" $dir/java/*
		sed -i "s/target_mq_host_name/${IP_host}/" $dir/public/java/*
		#gu-bei的回调接口都改成外网接口
		
		sed -i "s/ip_last/$ip_last_num/g" $dir/java/*
		sed -i "s/ip_last/$ip_last_num/g" $dir/public/java/*
		
		#python项目发布
		mkdir -p $dir/python
		cp -rf /home/config_files/python/* $dir/python/
		sed -i "s/target_host_name/${IP_host}/" $dir/python/*
		sed -i "s/ip_last/$ip_last_num/g" $dir/python/*

		#node项目发布
		mkdir -p $dir/node
		mkdir -p $dir/public/node
		cp -rf /home/config_files/node/* $dir/node/
		cp -rf /home/config_files/node/* $dir/public/node/
		sed -i "s/target_host_name/${IP_host}/" $dir/node/*
		sed -i "s/target_host_name/${IP_host}/g" $dir/public/node/*
		sed -i "s/ip_last/$ip_last_num/g" $dir/node/*
		sed -i "s/ip_last/$ip_last_num/g" $dir/public/node/*

		#ui配置发布
		mkdir -p $dir/ui
		mkdir -p $dir/public/ui
		cp -rf /home/config_files/ui/* $dir/ui/
		cp -rf /home/config_files/ui/* $dir/public/ui/
		sed -i "s/target_host_name/${IP_host}/g" $dir/ui/*
		sed -i "s/target_host_name/${IP_host}/g" $dir/public/ui/*
		
		sed -i "s/ip_last/$ip_last_num/g" $dir/public/ui/*
		sed -i "s/ip_last/$ip_last_num/g" $dir/ui/*
		
		#替换公网
		for multi in ${multis[@]}
		do
		{
			pro=`echo $multi | awk -F '|' '{print $1}'`
			port=`echo $multi | awk -F '|' '{print $2}'`
			sed -i "s/${IP_host}:$port/${pro}-${ip_last_num}.${public_ip}/g" $dir/public/java/*
			sed -i "s/${IP_host}:$port/${pro}-${ip_last_num}.${public_ip}/g" $dir/public/node/*
			sed -i "s/${IP_host}:$port/${pro}-${ip_last_num}.${public_ip}/g" $dir/public/ui/*
		}
		done
		#ngxin conf.d发布
		mkdir -p $dir/nginx_conf.d
		cp -rf /home/config_files/nginx_conf.d/* $dir/nginx_conf.d/
		#baitiao pem发布
		mkdir -p $dir/pem_file
		cp -rf /home/config_files/pem_file/* $dir/pem_file/
		echo "`date +%T.%N` 结束 ${IP_host}"
		echo "---------"
		echo >&1000
	}&
done
wait

echo "sh /home/qa-deploy-utils/qa_shell_script/exception_sub_shell.sh"
sh /home/qa-deploy-utils/qa_shell_script/exception_sub_shell.sh 
