#!/bin/bash
project_type=$1
is_public_ip=$2
ip=$3
pwd_path="/home/qa-deploy-utils/qa_shell_script"
config_server="$pwd_path/config_server"
project_path=`cat $config_server/project_path.sh`
config_path=`cat $config_server/config_path.sh`



function buildNginx()
{
	# 第二步   不关机使得nginx生效
	sh $config_server/show_info.sh nginx.config_d "打包BUILD" nginx配置文件生效 $2
	nginx -t;  nginx -s reload
}

if [ "$project_type" = "java" ]; then
	java_projects=(`node $config_server/get_project_config.js  -type java -attr name`)
	for project_name in ${java_projects[@]}
	do
		sh $pwd_path/base_script/buildJava.sh $project_name $config_server $project_path
		# buildJavaProject $project
	done
elif [ "$project_type" = "ui" ]; then
	ui_projects=(`node $config_server/get_project_config.js  -type ui -attr name`)
	for project_name in ${ui_projects[@]}
	do
		sh $pwd_path/base_script/buildUi.sh $project_name $config_server $project_path
		# buildUiProject $project
	done
	buildNginx
elif [ "$project_type" = "node" ]; then
	node_projects=(`node $config_server/get_project_config.js  -type node -attr name`)
	for project_name in ${node_projects[@]}
	do
		sh $pwd_path/base_script/buildNode.sh $project_name $config_server $project_path
		# buildNodeProject $project
	done
elif [ "$project_type" = "python" ]; then
	python_projects=(`node $config_server/get_project_config.js  -type python -attr name`)
	for project_name in ${python_projects[@]}
	do
		sh $pwd_path/base_script/buildPython.sh $project_name $config_server $project_path
		# buildPythonProject $project
	done
else
	java_projects=(`node $config_server/get_project_config.js  -type java -attr name`)
	for project_name in ${java_projects[@]}
	do
		sh $pwd_path/base_script/buildJava.sh $project_name $config_server $project_path
		# buildJavaProject $project $ip
	done
	python_projects=(`node $config_server/get_project_config.js  -type python -attr name`)
	for project_name in ${python_projects[@]}
	do
		sh $pwd_path/base_script/buildPython.sh $project_name $config_server $project_path
		# buildPythonProject $project $ip
	done
	node_projects=(`node $config_server/get_project_config.js  -type node -attr name`)
	for project_name in ${node_projects[@]}
	do
		sh $pwd_path/base_script/buildNode.sh $project_name $config_server $project_path
		# buildNodeProject $project $ip
	done
	ui_projects=(`node $config_server/get_project_config.js  -type ui -attr name`)
	for project_name in ${ui_projects[@]}
	do
		sh $pwd_path/base_script/buildUi.sh $project_name $config_server $project_path
		# buildUiProject $project $ip
	done
	buildNginx
fi
