#!/bin/bash
project_type=$1
git_branch=$2
ip=$3
pwd_path="/home/qa-deploy-utils/qa_shell_script"
config_server="$pwd_path/config_server"
project_path=`cat $config_server/project_path.sh`
config_path=`cat $config_server/config_path.sh`

function getCode()
{
	projects=(`node $config_server/get_project_config.js  -type $1 -attr name`)
	for project in ${projects[@]}
	do
		desc=`node $config_server/get_project_config.js  -name $project -attr desc`
		type=`node $config_server/get_project_config.js  -name $project_name -attr type`
        	if [ "$type" = "node" ];then
                	command2=`node $config_server/get_project_config.js  -name $project_name -attr command2`
                	command2
        	fi
		cd $project_path
		project_folder=`find ./ -maxdepth 1 -name "$project"`
		if [ -n "$project_folder" ];then
			echo "sh $config_server/show_info.sh $project pull代码 $desc $2"
			sh $config_server/show_info.sh $project pull代码 $desc $2
			cd ./$project
			git checkout ./
			git fetch
			git pull
			if [ -n "$git_branch" ]; then
				git checkout -f $git_branch
			fi
			git pull
		else
			sh $config_server/show_info.sh $project clone代码 $desc $2
			git_path=`node $config_server/get_project_config.js  -name $project -attr git_path`
			git clone $git_path
		fi
	done
}

if [ "$project_type" = "java" ]
then
	getCode java
elif [ "$project_type" = "ui" ]
then
	getCode ui
elif [ "$project_type" = "node" ]
then
	getCode node
elif [ "$project_type" = "python" ]
then
	getCode python
else
	getCode java $ip
	getCode python $ip
	getCode node $ip
	getCode ui $ip
fi	
