#!/usr/bin/env bash
# -------------------------------------------------------------------------------
# Filename:    java_deploy.sh
# Revision:    1.0
# Date:        2016/09
# Author:      Xiaolin.zhu
# Description: 该脚本根据git的分支名称（branch name）导出（checkout）不同的分支。
# Usage：used by ../deploy/*_deploy.sh
# -------------------------------------------------------------------------------
branch_name=$1
profile=test

if [ -z ${branch_name} ]; then
    echo "checkout default branch master"
    git pull
else
    echo "checkout specified branch $1"
    which git
    git checkout ${branch_name}
    if [ $? = 0 ]; then
    	echo "checkout branch $1 is ok".
        git pull
	else
    	echo "Fail to checkout branch $1".
    	exit -1
	fi 
fi

