#!/bin/bash
project_name=$1
is_public_ip=$2
ip=$3
pwd_path="/home/qa-deploy-utils/qa_shell_script"
config_shell_path="$pwd_path"
config_server="$pwd_path/config_server"
project_type=`node $config_server/get_project_config.js  -name $project_name -attr type`
project_path=`cat $config_server/project_path.sh`
config_path=`cat $config_server/config_path.sh`

if [ -z "$project_name" ];then
	echo "清输入项目名称"
	exit -1
fi

if [ "$project_type" = "java" ]; then
	sh $pwd_path/base_script/restartJava.sh $project_name $config_server $project_path $ip
	# restartJavaProject $project_name $3
elif [ "$project_type" = "node" ]; then
	sh $pwd_path/base_script/restartNode.sh $project_name $config_server $project_path $ip
	# restartNodeProject $project_name $3
elif [ "$project_type" = "python" ]; then
	sh $pwd_path/base_script/restartPython.sh $project_name $config_server $project_path $ip
	# restartPythonProject $project_name $3
elif [ "$project_type" = "ui" ]; then
	sh $pwd_path/base_script/restartUi.sh $project_name $config_server $project_path $ip
	# restartUiProject $project_name $3
fi
