#!/usr/bin/env bash
# -------------------------------------------------------------------------------
# Filename:    publish_db_schema_to_all_env.sh
# Revision:    1.0
# Date:        2017/01
# Author:      dekun.dai
# Description: 向所有测试环境下发最新表结构
# -------------------------------------------------------------------------------

source ~/.bash_profile
source ~/.profile

work_dir=/home/quant_group/test-utils/db-utils

if [ $# -gt 0 ]; then
	echo "---------------"
	echo "ip_list: $*"
	echo "共有: $# 个需同步"
else
	echo "---参数不正确---"
	echo "Usage:sh publish_db_schema_to_all_env.sh 192.168.x.x"
  echo "---------------"
	exit 1
fi

for host in "$@"
do
    sh $work_dir/db_schema_sync.sh 192.168.4.253 xyqb_query default ${host} qa qatest all
done