#!/bin/bash
project_name=$1
git_branch=$2
pwd_path="/home/qa-deploy-utils/qa_shell_script"
config_server="$pwd_path/config_server"
project_path=`cat $config_server/project_path.sh`
config_path=`cat $config_server/config_path.sh`

echo -e "\033[40;32m 执行2_get_code_by_name \033[0m"


cd $project_path
project_folder=`find ./ -maxdepth 1 -name "$project_name"`
if [ -n "$project_folder" ];then
	desc=`node $config_server/get_project_config.js  -name $project_name -attr desc`
	sh $config_server/show_info.sh $project_name pull代码 $desc
	cd ./$project_name
	git checkout ./
	if [ -n "$git_branch" ]; then
		echo "checkout specified branch $git_branch"
		git checkout -f $git_branch
		if [ $? = 0 ]; then
        	echo "checkout branch $git_branch is ok".
        	git pull
        else
       		echo "Fail to checkout branch $git_branch".
        	exit 128
        fi
	else
		echo "checkout default branch master"
		git checkout -f master
		git pull
	fi
else
	desc=`node $config_server/get_project_config.js  -name $project_name -attr desc`
	sh $config_server/show_info.sh $project_name clone代码 $desc
	git_path=`node $config_server/get_project_config.js  -name $project_name -attr git_path`
	git clone $git_path
fi
