#!/bin/bash
project_type=$1
is_public_ip=$2
ip=$3
pwd_path="/home/qa-deploy-utils/qa_shell_script"
config_shell_path="$pwd_path"
config_server="$pwd_path/config_server"
project_path=`cat $config_server/project_path.sh`
config_path=`cat $config_server/config_path.sh`
# node4_path=`cat $config_server/node_4_path.sh`
# node7_path=`cat $config_server/node_7_path.sh`
# profile=test
# max_wait_log_generate_time=50
# max_wait_ack_time=500
# ack_phrase="Started\ Bootstrap"
# time=`date +%Y_%m_%d_%H_%M_%S`

function restartJavaProject()
{
	projects=(`node $config_server/get_project_config.js  -type java -attr name`)
	echo ${projects[@]}
	for project in ${projects[@]}
	do
		sh $pwd_path/base_script/restartJava.sh $project_name $config_server $project_path
		# desc=`node $config_server/get_project_config.js  -name $project -attr desc`
# 		run_command=`node $config_server/get_project_config.js  -name $project -attr command`
# 		sh $config_server/show_info.sh $project 重新启动 $desc $1
# 		cd $project_path/$project
# 		P_UUID=`ps -ef|grep ${project}.jar |grep -v 'grep'|awk '{print $2}'`
# 		if [ -n "${P_UUID}" ];then
# 			echo "KILL $project PPID=${P_UUID}"
# 			echo `kill -9 ${P_UUID}`
# 			sleep 2s
# 		fi
# 		log_name=`node $config_server/get_project_config.js  -name $project -attr log_name`
# 		mv $project_path/logs/$log_name $project_path/logs/$project.log.$time
# 		config_file=`find ./ -maxdepth 2 -name "application.properties"`
# 		if [ -n "$config_file" ]
# 		then
# 			echo "already have application.properties"
# 		else
# 			echo "no have application.properties"
# 			if $is_public_ip && [ -n "$is_public_ip" ]
# 			then
# 				echo "ln -s $config_path/public/java/${project}.* /home/quant_group/${project}/application.properties"
# 				ln -s $config_path/public/java/${project}.* /home/quant_group/${project}/application.properties
# 			else
# 				echo "ln -s $config_path/java/${project}.* /home/quant_group/${project}/application.properties"
# 				ln -s $config_path/java/${project}.* /home/quant_group/${project}/application.properties
# 			fi
# 		fi
#
# 		echo "$run_command"
#
# if  [[ $project == "redpacket" ]]; then
#         echo `java -Xmx512m -XX:PermSize64m -Xloggc:/tmp/${project}.log -XX:+PrintGCDetails -XX:+PrintGCTimeStamps  -jar ${project}.jar --worker 1 --currentWorker 1 -t -ts > /dev/null 2>&1 &`
# else
#         echo `java -Xmx512m -XX:PermSize64m -Xloggc:/tmp/${project}.log -XX:+PrintGCDetails -XX:+PrintGCTimeStamps  -jar ${project}.jar --worker 1 --currentWorker 1 -t > /dev/null 2>&1 &`
# fi		


	sleep 10s
		#ack "$ack_phrase" $project_path/logs/$log_name ${max_wait_log_generate_time} ${max_wait_ack_time}

	done
}

function restartNodeProject()
{
	projects=(`node $config_server/get_project_config.js  -type node -attr name`)
	for project in ${projects[@]}
	do
		sh $pwd_path/base_script/restartNode.sh $project_name $config_server $project_path
		# desc=`node $config_server/get_project_config.js  -name $project -attr desc`
		# stop_command=`node $config_server/get_project_config.js  -name $project -attr command2`
		# sh $config_server/show_info.sh $project 重新启动 $desc $1
		# cd $project_path/$project
		#
		# $stop_command
		# # forever stop $project
		# # forever stop $project-www
		# # pm2 stop $project
		# start_command=`node $config_server/get_project_config.js  -name $project -attr command`
		# $start_command
		# # setup_path_temp=`find ./ -maxdepth 2 -path "./node_modules"  -prune -o -type f -name "app.js" -print`
		# # echo "------setup_path_temp:$setup_path_temp"
		# #
		# # echo `forever start -a -s --uid $project  ${setup_path_temp}`
		# #
		# # setup_path_temp_for_appbackent=`find ./ -maxdepth 2 -path "./node_modules" -prune -o -type f -name "www" -print`
		# # if [ -n "$setup_path_temp_for_appbackent" ];then
		# # 	echo "-----project:$project while be run command:  python $python_project_path --mode=beta --port=$port > /dev/null 2>&1 &"
		# # 	echo `forever start -a -s --uid $project-www ${setup_path_temp_for_appbackent}`
		# # fi
	done
}

function restartPythonProject()
{
	projects=(`node $config_server/get_project_config.js  -type python -attr name`)
	for project in ${projects[@]}
	do
		sh $pwd_path/base_script/restartPython.sh $project_name $config_server $project_path
		# desc=`node $config_server/get_project_config.js  -name $project -attr desc`
# 		port=`node $config_server/get_project_config.js  -name $project -attr port`
#
# 		sh $config_server/show_info.sh $project 重新启动 $desc $1
# 		cd $project_path/$project
# 		setup_path_temp=`find ./ -name "run.py"`
# 		python_project_path=$project_path/$project${setup_path_temp/\.\//\/}
#
# 		P_UUID=`ps -ef|grep port=$port |grep -v 'grep'|awk '{print $2}'`
# 		if [[ "${P_UUID}" != "" ]];then
# 			echo "KILL $project PPID=${P_UUID}"
# 			echo `kill -9 ${P_UUID}`
# 			sleep 3
# 		fi
#
#
# 		echo "-----project:$project while be run command:  python $python_project_path --mode=beta --port=$port > /dev/null 2>&1 &"
# 		echo `python $python_project_path --mode=beta --port=$port > /dev/null 2>&1 &`
	done
}

function restartUiProject()
{
	nginx -t;  nginx -s reload
}

#acknowledge whether the deploy start OK
# function ack()
# {
#     ack_phrase="$1"
#     log_path="$2"
#     max_wait_log_generate_time="$3"
#     max_wait_ack_time="$4"
#     wait_log_generate_time=0
#     wait_ack_time=0
#     echo "begin acknowledge whether the deploy start OK, ACK_PHRASE=${ack_phrase}, log_path=${log_path}"
#     while [ ! -f ${log_path} ]
#     do
#         echo "wait_log_generate_time is ${wait_log_generate_time}, max_wait_log_generate_time is ${max_wait_log_generate_time} "
#         if ((${wait_log_generate_time}>${max_wait_log_generate_time}))
#         then
#             echo "the log generated time exceed the limit"
#             exit -1
#         fi
#         echo 'the log does not exist, wait for 5 seconds'
#         sleep 5
#         let "wait_log_generate_time+=5"
#     done
#     echo "listen for the log ack..."
#     for ((i=0;;))
#     do
#         bootstrap_flag=`cat ${log_path} |grep "${ack_phrase}"| wc -l`
#         if [ "${bootstrap_flag}" = 0 ] && [ "${max_wait_ack_time}" -gt "${wait_ack_time}" ]
#         then
#             sleep 5
#             let "wait_ack_time+=5"
#             echo "waiting for bootstrap flag for ${wait_ack_time}"
#         elif [ "${bootstrap_flag}" = 1 ]
#         then
#             echo "server is start~ log_path:$log_path"
#             break
#         else
#             echo "server not startup in ${max_wait_ack_time} seconds.. log_path:$log_path"
#             exit -1
#         fi
#     done
# }

if [ "$project_type" = "java" ]; then
	restartJavaProject
elif [ "$project_type" = "node" ]; then
	restartNodeProject
elif [ "$project_type" = "python" ]; then
	restartPythonProject
elif [ "$project_type" = "ui" ]; then
	restartUiProject
else
	echo "***restart java***"
	restartJavaProject $ip
	echo "***restart python***"
	restartPythonProject $ip
	echo "***restart node***"
	restartNodeProject $ip
	echo "***restart ui***"
	restartUiProject $ip
fi
