#!/usr/bin/env bash
# -------------------------------------------------------------------------------
# Filename:    database_sync.sh
# Revision:    1.0
# Date:        2016/09
# Author:      Xiaolin.zhu
# Description: 该脚本调用其他脚本实现测试数据库的同步
# -------------------------------------------------------------------------------

source ~/.bash_profile

echo "部署参数：database_name: $1, mysql_host: $2, re_dumpDB？: $3, re_replace_ip?: $4, re_importDB？$5"

database_name=$1
mysql_host=$2
re_dumpDB=$3
re_replace_ip=$4
re_importDB=$5
use_public_ip =$6

work_path=/home/quant_group
# work_path=/Users/eileen/QG/dev
db_backup=$work_path/db_backup
utils_path=$work_path/qa-deploy-utils

function database_ops()
{
	database=$1
	echo $database
	if [ "$re_dumpDB" = true ]; then
    echo "Step 1: dumpDB: $database"
	sh ${utils_path}/sh-utils/center/database_backup.sh $database $db_backup
	else
	    echo "Step 1: skip dumpDB"
	fi

	if [ "$re_replace_ip" = true ]; then
		echo "Step 2: replace domain name in tables: $database $mysql_host"
		sh ${utils_path}/sh-utils/center/database_replace_ip.sh $database $mysql_host $db_backup "${use_public_ip}"
	else
	    echo "Step 2: skip replace_ip"
	fi

	if [ "$re_importDB" = true ]; then
	    echo "Step 3: importDB: $database $mysql_host"
		sh ${utils_path}/sh-utils/center/database_import.sh $database $mysql_host $db_backup
	else
	    echo "Step 3: skip importDB"
	fi
}

database_list='xyqb_user merchant xyqb xyqb_app payment_center risk_control dujiangyan mall qinqiong quartz contract financial_system gyxd offline sms-center spider_center'
if [[ "${database_name}" = "all" ]]
then
	echo "all database"
	for database in $database_list
	do
	    database_ops $database
        echo $database
	done
else
	database_ops $database_name
fi
