# -------------------------------------------------------------------------------
# Filename:    db_import.sh
# Revision:    1.1
# Date:        2017/02
# Author:      dekun.dai
# Description: 导入基础数据
# Usage：used by ../deploy/database_sync.sh
# -------------------------------------------------------------------------------

database_name=$1
mysql_host=$2
db_sub_backup_folder=$3
target_db_port=$4

echo "cd $db_sub_backup_folder"
cd $db_sub_backup_folder

for entry in `ls`
do
	table_name=${entry%.sql}
	echo "mysql -h $mysql_host -P $target_db_port -uqa -pqatest $database_name -e \"truncate $table_name\""
	mysql -h $mysql_host -P $target_db_port -uqa -pqatest $database_name -e "truncate $table_name"
	echo "mysql -h $mysql_host -P $target_db_port -uqa -pqatest $database_name < $entry"
	mysql -h $mysql_host -P $target_db_port -uqa -pqatest $database_name < $entry
	if [ $? != 0 ];then
		echo "--- mysql -h $mysql_host -P $target_db_port -uqa -pqatest $database_name < $entry import error ---"
		exit -1
	fi
done
