#!/usr/bin/env bash
# -------------------------------------------------------------------------------
# Filename:    java_deploy.sh
# Revision:    1.0
# Date:        2016/09
# Author:      Xiaolin.zhu
# Description: 该脚本调用其他脚本实现js项目的自动化部署。目前deploy_xyqb-ui,deploy_di-ting-ui等 jenkins job使用了该脚本。
# -------------------------------------------------------------------------------
source ~/.bash_profile

echo "部署参数：module name: $1, branch name: $2, host address: $3, checkout branch again？$4， build UI again？ $5, npm and bower install? $6, remote copy again？$7"
module=$1
branch_name=$2
host=$3
checkout_branch=$4
build_ui=$5
npm_install=$6
remote_copy=$7

if [ -z $8 ]; then
    ui_sys_type="business_sys"
else
    ui_sys_type=$8
fi

use_public_ip=$9

replace=true
utils_path=/home/quant_group/qa-deploy-utils

if [ "$checkout_branch" = true ]; then
    echo "Step 1: checkout branch: $branch_name"
	sh ${utils_path}/sh-utils/center/1_branch_checkout.sh $branch_name
else
    echo "Step 1: skip checkout branch: $branch_name"
fi

if [ "$build_ui" = true ]; then
    echo "Step 2: build project: $branch_name"
	sh ${utils_path}/sh-utils/center/2_build_ui.sh $module $npm_install $ui_sys_type
else
    echo "Step 2: skip build project: $branch_name"
fi

if [ "$remote_copy" = true ]; then
    echo "Step 3: remote copy project. "
	sh ${utils_path}/sh-utils/center/3_remote_copy.sh $module $host ui
else
    echo "Step 3: skip remote copy project"
fi

if [ "$replace" = true ]; then
	echo "Step 4: replace static files and replace ip. "
    ssh root@${host} sh ${utils_path}/sh-utils/worker/ui_replace_ip.sh $module $host $ui_sys_type "$use_public_ip"
else
    echo "Step 4: replace static files and replace ip"
fi


