#!/usr/bin/env bash
# -------------------------------------------------------------------------------
# Filename:    db_schema_sync.sh
# Revision:    1.0
# Date:        2016/12
# Author:      dekun.dai
# Description: 实现数据库表结构同步
# -------------------------------------------------------------------------------

source ~/.bash_profile
source ~/.profile
pwd_path="/home/qa-deploy-utils"

if [ $# -ne 11 ]; then
	echo "---------------"
	echo "source_db_infos：source_db_host: $1, source_db_user: $2"
	echo "target_db_infos：target_db_host: $4, target_db_user: $5"
	echo "target_db_port: ${11}"
	echo "sync_db_name: $7, re_replace_ip: $8"
	echo "delete_business_data: $9"
	echo "use_cache: ${10}"
	echo "--- 参数不正确 ---"
	echo "Usage:sh db_schema_sync.sh source_db_host source_db_user source_db_pwd target_db_host target_db_user target_db_pwd sync_db_name"
	echo "---------------"
	exit 1
fi

work_dir=/home/qa-deploy-utils/db-utils
sync_config_folder=/home/db_sync_configs
db_backup_folder=/home/db_backups

source_db_host=$1
source_db_user=$2
source_db_pwd=`grep source_db_pwd $work_dir/config/db_config | cut -d "=" -f 2`

ip_value=$4

target_db_user=$5
target_db_pwd=$6

sync_db_name=$7
re_replace_ip=$8
delete_business_data=$9
use_cache=${10}
target_db_port=${11}

trap "exec 1000>&-;exec 1000<&-;exit 0" 2
tempfifo=$$.fifo
echo "mkfifo /tmp/$tempfifo"
mkfifo /tmp/$tempfifo
exec 1000<>/tmp/$tempfifo
rm -rf /tmp/$tempfifo

for ((i=1; i<=2; i++))
do
	echo >&1000
done

target_db_host=`sh $pwd_path/get-ip.sh $ip_value`

function db_schema_sync()
{
	database=$1
	uuid=$(uuidgen)
	config_file_name="$sync_config_folder/${database}_${uuid}_db_schema_sync_config.json"
	db_backup_sub_folders=$db_backup_folder/${uuid}
	
	echo "mkdir $db_backup_sub_folders"
	mkdir -p $db_backup_sub_folders
	mkdir -p $sync_config_folder
	
	echo "--- Step 1: generate_config_file: $config_file_name ---"
	echo "source infos: $source_db_host $source_db_user"
	echo "target infos: $target_db_host $target_db_port $target_db_user "
	echo "database_name is : $database"
	echo "delete_business_data : $delete_business_data"
	echo "use_cache : $use_cache"

	sh $work_dir/db_gen_config.sh $source_db_host $source_db_user $source_db_pwd $target_db_host $target_db_user $target_db_pwd $database $config_file_name $db_backup_sub_folders $use_cache $target_db_port
	
	cd $db_backup_sub_folders
	file_count=`ls -l | grep .sql$ | wc -l`
	echo "$db_backup_sub_folders/*.sql file count is $file_count"
	if [ "$file_count" -gt 0 ]; then
		echo "--- Step 2: replace domain name in tables: $database $db_backup_sub_folders ---"
		echo "--- Step 2: is re_replace_ip: $re_replace_ip ---"
		sh $work_dir/db_replace_ip.sh $database $target_db_host $db_backup_sub_folders $re_replace_ip $ip_value
	else
		echo "--- Skip step 2: replace domain name in tables: $database $db_backup_sub_folders ---"
	fi

	echo "--- Step 3: import basic data from backup file: $database $db_backup_sub_folders ---"
	sh $work_dir/db_import.sh $database $target_db_host $db_backup_sub_folders $delete_business_data $target_db_port
	if [ $? != 0 ];then echo "db_import.sh $database error";exit -1; fi
	
	echo "--- Step 4: sync schema: $database $target_db_host ---"
	#sync_cmd="mss -conf ${config_file_name} -sync"
	echo "mss -conf ${config_file_name} -sync > /dev/null"
	mss -conf ${config_file_name} -sync > /dev/null
	echo "mysql-schema-sync result:$?"
}

function run_sql_file()
{
	sync_db_name=$1
	echo "run sql files on ${target_db_host}'s $sync_db_name"
	sh $work_dir/db_execute_sql.sh $target_db_host $sync_db_name $target_db_port
}

database_list=`grep database_list $work_dir/config/db_config | cut -d "=" -f 2`

if [[ "$sync_db_name" = "all" ]];then
	echo "sync all database schema"
elif [[ "$sync_db_name" = "all(no_mall)" ]];then
	database_list=`echo $database_list | sed 's#mall ##g'`
	echo "sync all(no_mall) database schema"
else
	database_list=$sync_db_name
	echo "sync single database schema:$sync_db_name"
fi

echo "database_list:${database_list}"
for db_name in $database_list
do
	read -u1000
	{
		echo "----------------------------------------------------"
		echo "--- start sync $db_name ---"
		db_schema_sync $db_name
		run_sql_file $db_name
		echo "--- end sync $db_name ---"
		echo >&1000
	}&
done
wait
echo "----------------------------------------------------"

