#!/bin/bash

scriptname=$(basename $0)
lock="/var/run/${scriptname}"

exec 200>$lock
#flock -n 200 || echo "sub.sh 正在被其他人执行，请稍后再试" && exit 1
#flock -n 200 || exit 1
flock -n 200
if [ $? -ne 0 ];then
	echo "$scriptname 正在被其他人执行，预计一分钟，请稍后再试~"
	exit 1
fi

## The code:
pid=$$
echo $pid 1>&200

IP_host_first="192.168.4."
public_ip="q-gp.com"    #"139.198.2.95"
pwd_path="/home/qa-deploy-utils/qa_shell_script"
config_server="$pwd_path/config_server"
ips=`cat $config_server/get_env_ip.sh`
counts=`echo $ips | awk '{print NF}'`

mkdir -p /home/sub_config_file_dont_rm
multis=`node $config_server/get_project_config.js  -type multi -attr port`

trap "exec 1000>&-;exec 1000<&-;exit 0" 2
tempfifo=$$.fifo
mkfifo /tmp/$tempfifo
exec 1000<>/tmp/$tempfifo
rm -rf /tmp/$tempfifo

for ((i=1; i<=6; i++))
do
	echo >&1000
done

echo "共要生成$counts个环境的配置文件"
echo "并发生成6个环境的配置文，负载最大时为4~"
#for ip_last_num in '15'
for ip_last_num in ${ips[@]} 
do
    read -u1000
    {
	echo "`date +%T:%N` 开始生成 ${IP_host_first}${ip_last_num}"
	cd /home/sub_config_file_dont_rm
	mkdir -p ${IP_host_first}${ip_last_num}
	cd ${IP_host_first}${ip_last_num}
	dir=`pwd`
	
	#java项目发布
	mkdir -p $dir/java
	mkdir -p $dir/public/java
	cp -rf /home/config_files/java/* $dir/java/
	cp -rf /home/config_files/java/* $dir/public/java/
	sed -i "s/target_host_name/${IP_host_first}${ip_last_num}/" $dir/java/*
	sed -i "s/target_host_name/${IP_host_first}${ip_last_num}/" $dir/public/java/*
	sed -i "s/target_mq_host_name/${IP_host_first}${ip_last_num}/" $dir/java/*
	sed -i "s/target_mq_host_name/${IP_host_first}${ip_last_num}/" $dir/public/java/*
	#gu-bei的回调接口都改成外网接口
	#sed -i "s/callback=http:\/\/${IP_host_first}${ip_last_num}:7006/callback=http:\/\/${public_ip}:${ip_last_num}06/g" $dir/java/gu-bei.properties
	#sed -i "s/pay_notify_url=http:\/\/${IP_host_first}${ip_last_num}:7006/pay_notify_url=http:\/\/${public_ip}:${ip_last_num}06/g" $dir/java/gu-bei.properties

	sed -i "s/ip_last/$ip_last_num/g" $dir/java/*
	sed -i "s/ip_last/$ip_last_num/g" $dir/public/java/*
	
	#python项目发布
	mkdir -p $dir/python
	cp -rf /home/config_files/python/* $dir/python/
	sed -i "s/target_host_name/${IP_host_first}${ip_last_num}/" $dir/python/*
	sed -i "s/ip_last/$ip_last_num/g" $dir/python/*

	#node项目发布
	mkdir -p $dir/node
	mkdir -p $dir/public/node
	cp -rf /home/config_files/node/* $dir/node/
	cp -rf /home/config_files/node/* $dir/public/node/
	sed -i "s/target_host_name/${IP_host_first}${ip_last_num}/" $dir/node/*
	sed -i "s/target_host_name/${IP_host_first}${ip_last_num}/g" $dir/public/node/*
	sed -i "s/ip_last/$ip_last_num/g" $dir/node/*
	sed -i "s/ip_last/$ip_last_num/g" $dir/public/node/*

	#ui配置发布
	mkdir -p $dir/ui
	mkdir -p $dir/public/ui
	cp -rf /home/config_files/ui/* $dir/ui/
	cp -rf /home/config_files/ui/* $dir/public/ui/
	sed -i "s/target_host_name/${IP_host_first}${ip_last_num}/g" $dir/ui/*
	sed -i "s/target_host_name/${IP_host_first}${ip_last_num}/g" $dir/public/ui/*
  	#if [ $ip_last_num -lt 100 ]; then
      	#	sed -i "s/target_host_name:7/${public_ip}:${ip_last_num}/g" $dir/public/ui/*
  	#else
  	#fi
	sed -i "s/ip_last/$ip_last_num/g" $dir/public/ui/*
	sed -i "s/ip_last/$ip_last_num/g" $dir/ui/*
	
	#替换公网
	for multi in ${multis[@]}
	do
	{
        	pro=`echo $multi | awk -F '|' '{print $1}'`
        	port=`echo $multi | awk -F '|' '{print $2}'`
		#find $dir/public/ -type f  -print | xargs -i sed -i "s/${IP_host_first}${ip_last_num}:$port/${pro}-${ip_last_num}.${public_ip}/g" {}
		#echo "sed -i "s/${IP_host_first}${ip_last_num}:$port/${pro}-${ip_last_num}.${public_ip}/g" $dir/public/*"
		sed -i "s/${IP_host_first}${ip_last_num}:$port/${pro}-${ip_last_num}.${public_ip}/g" $dir/public/java/*
		sed -i "s/${IP_host_first}${ip_last_num}:$port/${pro}-${ip_last_num}.${public_ip}/g" $dir/public/node/*
		sed -i "s/${IP_host_first}${ip_last_num}:$port/${pro}-${ip_last_num}.${public_ip}/g" $dir/public/ui/*
	}
	done
	#find $dir/public/ -type f  -print | xargs -i sed -i "s/${IP_host_first}${ip_last_num}/www.${public_ip}/g" {}

	#ngxin conf.d发布
	mkdir -p $dir/nginx_conf.d
	cp -rf /home/config_files/nginx_conf.d/* $dir/nginx_conf.d/
	#baitiao pem发布
	mkdir -p $dir/pem_file
	cp -rf /home/config_files/pem_file/* $dir/pem_file/
	# sed -i "s/target_host_name/${IP_host_first}${ip_last_num}/" $dir/nginx_conf.d/*
	echo "`date +%T:%N` 结束 ${IP_host_first}${ip_last_num}"
	echo "---------"
	echo >&1000
    }&
done
wait

echo "sh /home/qa-deploy-utils/qa_shell_script/exception_sub_shell.sh"
sh /home/qa-deploy-utils/qa_shell_script/exception_sub_shell.sh 
