#!/bin/bash
project_name=$1
is_public_ip=$2
ip=$3
pwd_path="/home/qa-deploy-utils/qa_shell_script"
config_server="$pwd_path/config_server"
project_path=`cat $config_server/project_path.sh`
project_type=`node $config_server/get_project_config.js  -name $project_name -attr type`
config_path=`cat $config_server/config_path.sh`

if [ -z "$project_name" ];then
	echo "清输入项目名称"
	exit -1
fi

profile=test

host=`/sbin/ifconfig -a|grep inet|grep -v 127.0.0.1|grep -v inet6|awk '{print $2}'|tr -d "addr:"`
#echo "host=$host"
hosts=(${host//\./ })
suffix=${hosts[3]}


if [ "$project_type" = "java" ]; then
	sh $pwd_path/base_script/buildJava.sh $project_name $config_server $project_path $ip
	# buildJavaProject $project_name $3
elif [ "$project_type" = "ui" ]; then
	sh $pwd_path/base_script/buildUi.sh $project_name $config_server $project_path $ip
	# buildUiProject $project_name $3
elif [ "$project_type" = "node" ]; then
	sh $pwd_path/base_script/buildNode.sh $project_name $config_server $project_path $ip
	# buildNodeProject $project_name $3
elif [ "$project_type" = "python" ]; then
	sh $pwd_path/base_script/buildPython.sh $project_name $config_server $project_path $ip
	# buildPythonProject $project_name  $3
fi

