#!/bin/bash
project_type=$1
branch_name=$2
public_ip=$3
ip=$4
if [ $branch_name = "aaa" ];then
	branch_name=""
fi

pwd_path="/home/qa-deploy-utils/qa_shell_script"
config_server="$pwd_path/config_server"
project_path=`cat $config_server/project_path.sh`
config_path=`cat $config_server/config_path.sh`

trap "exec 1000>&-;exec 1000<&-;exit 0" 2
tempfifo=$$.fifo
echo "mkfifo /tmp/$tempfifo"
mkfifo /tmp/$tempfifo
exec 1000<>/tmp/$tempfifo
rm -rf /tmp/$tempfifo

echo "********"
if [ "$project_type" = "all" ]
then
	projects=(`node $config_server/get_project_config.js  -type ui -attr name`)
        echo ${#projects[@]}"个ui项目:"  ${projects[@]}
	projects=(`node $config_server/get_project_config.js  -type java -attr name`)
        echo ${#projects[@]}"个java项目:"  ${projects[@]}
	projects=(`node $config_server/get_project_config.js  -type node -attr name`)
        echo ${#projects[@]}"个node项目:"  ${projects[@]}
	projects=(`node $config_server/get_project_config.js  -type python -attr name`)
        echo ${#projects[@]}"个python项目:"  ${projects[@]}
else
	for ((i=1; i<=6; i++))
	do
		echo >&1000
	done
	projects=(`node $config_server/get_project_config.js  -type $1 -attr name`)
	echo ${#projects[@]}"个"$1"项目:"  ${projects[@]}
	
	for project_name in ${projects[@]}
	do
		read -u1000
		{
			sh /home/qa-deploy-utils/qa_shell_script/2_get_code_by_name.sh $project_name "$branch_name" $4
			if [ $? = 0 ]; then
				echo "--- $project_name 2_get_code_by_name ok ---"
			else
				echo "--- $project_name 2_get_code_by_name fail ---"
				echo >&1000
				exit -1
			fi
 
			sh /home/qa-deploy-utils/qa_shell_script/3_link_config_file_by_name.sh $project_name $public_ip $4
			if [ $? = 0 ]; then
				echo "--- $project_name 3_link_config_file_by_name ok ---"
			else
				echo "--- $project_name 3_link_config_file_by_name fail ---"
				echo >&1000
				exit -1
			fi

			sh /home/qa-deploy-utils/qa_shell_script/4_build_by_name.sh $project_name $public_ip $4
			if [ $? = 0 ]; then
				echo "--- $project_name 4_build_by_name ok ---"
			else
				echo "--- $project_name 4_build_by_name fail ---"
				echo >&1000
				exit -1
			fi

			sh /home/qa-deploy-utils/qa_shell_script/5_restart_by_name.sh $project_name $public_ip $4
			if [ $? = 0 ]; then
				echo "--- $project_name 5_restart_by_name ok ---"
			else
				echo "--- $project_name 5_restart_by_name fail ---"
				echo >&1000
				exit -1
			fi
			echo >&1000
		}&
	done
	wait
fi
#echo "********"
#echo "********sh 2_get_code_by_type.sh $project_type $branch_name $ip********"
#sh 2_get_code_by_type.sh $project_type $branch_name $ip
#echo "********sh 3_link_config_file_by_type.sh $project_type $public_ip $ip********"
#sh 3_link_config_file_by_type.sh $project_type $public_ip $ip
#echo "********sh 4_build_by_type.sh $project_type $public_ip $ip********-"
#sh 4_build_by_type.sh $project_type $public_ip $ip
#echo "********sh 5_restart_by_type.sh $project_type $public_ip $ip********"
#sh 5_restart_by_type.sh $project_type $public_ip $ip

