#-*- coding: UTF-8 -*-   
import sys
sys.path.append("..")
import os
from flask import Flask, jsonify, request,json
from utils.crossdomain import crossdomain

app = Flask(__name__)

mockdir = os.path.dirname(os.path.realpath(__file__))

# ***
# *** *** *** 1 *** *** 
# *** 绑卡请求接口
# *** https://ok.yeepay.com/payapi/api/tzt/invokebindbankcard
# *** HTTP 请求方式:POST
# ***
@app.route("/payapi/api/tzt/invokebindbankcard", methods=['POST', 'OPTIONS'])
@crossdomain(origin='*')
def invokebindbankcard():
    
    if request.method == 'OPTIONS': return ''
    if request.method == 'POST':
        json_data = open(mockdir+'/../json/yeepay_invokebindbankcard.json')
        return jsonify(json.load(json_data))

# ***
# *** *** *** 2 *** *** 
# *** 确定绑卡接口
# *** https://ok.yeepay.com/payapi/api/tzt/confirmbindbankcard
# *** HTTP 请求方式:POST
# ***
@app.route("/payapi/api/tzt/confirmbindbankcard", methods=['POST', 'OPTIONS'])
@crossdomain(origin='*')
def confirmbindbankcard():
    
    if request.method == 'OPTIONS': return ''
    if request.method == 'POST':
        json_data = open(mockdir+'/../json/yeepay_confirmbindbankcard.json')
        return jsonify(json.load(json_data))

# ***
# *** *** *** 3: not sure whether be used *** *** 
# *** 查询绑卡信息列表
# *** https://ok.yeepay.com/payapi/api/bankcard/authbind/list
# *** HTTP 请求方式:GET
# *** 请求参数:merchantaccount,identityid,identitytype,sign
# ***
@app.route("/payapi/api/bankcard/authbind/list", methods=['GET'])
@crossdomain(origin='*')
def bankcard_authbind_list():
    if request.method == 'GET':
        json_data = open(mockdir+'/../json/yeepay_bankcard_authbind_list.json')
        return jsonify(json.load(json_data))

# ***
# *** *** *** 4 *** *** 
# *** 银行卡信息查询
# *** https://ok.yeepay.com/payapi/api/bankcard/check
# *** HTTP 请求方式:POST
# *** 请求参数:merchantaccount,cardno,sign
# ***
@app.route("/payapi/api/bankcard/check", methods=['POST'])
@crossdomain(origin='*')
def bankcard_check():
    if request.method == 'POST':
        json_data = open(mockdir+'/../json/yeepay_bankcard_check.json')
        return jsonify(json.load(json_data))

# ***
# *** *** *** 5 *** *** 
# *** 支付请求接口
# *** https://ok.yeepay.com/payapi/api/tzt/pay/bind/reuqest
# *** HTTP 请求方式:POST
# *** 请求参数:merchantaccount,orderid,transtime,currency,currency,productname,productname,identityid,identitytype,card_top
# ***         card_last,orderexpdate,callbackurl,imeiuserip,ua,sign
# ***
@app.route("/payapi/api/tzt/pay/bind/reuqest", methods=['POST'])
@crossdomain(origin='*')
def pay_bind_request():
    if request.method == 'POST':
        json_data = open(mockdir+'/../json/yeepay_pay_bind_request.json')
        return jsonify(json.load(json_data))

# ***
# *** *** *** 6 *** *** 
# *** 发送短信验证码接口
# *** https://ok.yeepay.com/payapi/api/tzt/pay/validatecode/send
# *** HTTP 请求方式:POST
# *** 请求参数:merchantaccount,orderid,sign
# ***
@app.route("/payapi/api/tzt/pay/validatecode/send", methods=['POST'])
@crossdomain(origin='*')
def validatecode_send():
    if request.method == 'POST':
        json_data = open(mockdir+'/../json/yeepay_validatecode_send.json')
        return jsonify(json.load(json_data))

# ***
# *** *** *** 7 *** *** 
# *** 确认支付
# *** https://ok.yeepay.com/payapi/api/tzt/pay/confirm/validatecode
# *** HTTP 请求方式:POST
# *** 请求参数:merchantaccount,orderid,validatecode,sign
# ***
@app.route("/payapi/api/tzt/pay/confirm/validatecode", methods=['POST'])
@crossdomain(origin='*')
def confirm_validatecode():
    if request.method == 'POST':
        json_data = open(mockdir+'/../json/yeepay_confirm_validatecode.json')
        return jsonify(json.load(json_data))

# ***
# *** *** *** 8 *** *** 
# *** 支付结果查询
# *** https://ok.yeepay.com/payapi/api/query/order
# *** HTTP 请求方式:GET
# *** 请求参数:merchantaccount,orderid,sign
# ***
@app.route("/payapi/api/query/order", methods=['GET'])
@crossdomain(origin='*')
def query_order():
    if request.method == 'GET':
        json_data = open(mockdir+'/../json/yeepay_query_order.json')
        return jsonify(json.load(json_data))

# ***
# *** *** *** 9 *** *** 
# *** 提现接口
# *** https://ok.yeepay.com/payapi/api/tzt/withdraw
# *** HTTP 请求方式:POST
# *** 请求参数: TBD
# ***
@app.route("/payapi/api/tzt/withdraw", methods=['GET'])
@crossdomain(origin='*')
def withdraw():
    if request.method == 'GET':
        json_data = open(mockdir+'/../json/yeepay_withdraw.json')
        return jsonify(json.load(json_data))
# ***
# *** *** *** 10 *** *** 
# *** 提现查询接口
# *** https://ok.yeepay.com/payapi/api/tzt/drawrecord
# *** HTTP 请求方式:GET
# *** 请求参数:TBD
# ***
@app.route("/payapi/api/tzt/drawrecord", methods=['GET'])
@crossdomain(origin='*')
def drawrecord():
    if request.method == 'GET':
        json_data = open(mockdir+'/../json/yeepay_drawrecord.json')
        return jsonify(json.load(json_data))

# ***
# *** *** *** 11 *** *** 
# *** 可提现余额接口
# *** https://ok.yeepay.com/payapi/api/tzt/drawvalidamount
# *** HTTP 请求方式:GET
# *** 请求参数:TBD
# ***
@app.route("/payapi/api/tzt/drawvalidamount", methods=['GET'])
@crossdomain(origin='*')
def drawvalidamount():
    if request.method == 'GET':
        json_data = open(mockdir+'/../json/yeepay_drawvalidamount.json')
        return jsonify(json.load(json_data))

# ***
# *** *** *** 12: not sure whether used *** *** 
# *** 支付接口--不发送短验
# *** https://ok.yeepay.com/payapi/api/tzt/directbindpay
# *** HTTP 请求方式:POST
# *** 请求参数:TBD
# ***
@app.route("/payapi/api/tzt/directbindpay", methods=['GET'])
@crossdomain(origin='*')
def directbindpay():
    if request.method == 'GET':
        json_data = open(mockdir+'/../json/yeepay_directbindpay.json')
        return jsonify(json.load(json_data))

# ***
# *** *** *** 13 *** *** 
# *** 交易记录查询
# *** https://ok.yeepay.com/merchant/query_server/pay_single
# *** HTTP 请求方式:GET
# *** 请求参数:merchantaccount,orderid,yborderid,sign
# ***
@app.route("/merchant/query_server/pay_single", methods=['GET'])
@crossdomain(origin='*')
def pay_single():
    if request.method == 'GET':
        json_data = open(mockdir+'/../json/yeepay_pay_single.json')
        return jsonify(json.load(json_data))

# ***
# *** *** *** 14: not used in pay-center *** *** 
# *** 获取消费清算对账单记录
# *** https://ok.yeepay.com/merchant/query_server/pay_clear_data
# *** HTTP 请求方式:GET
# *** 请求参数:merchantaccount,startdate,enddate,sign
# ***
# @app.route("/merchant/query_server/pay_clear_data", methods=['GET'])
# @crossdomain(origin='*')
# def pay_clear_data():
#     if request.method == 'GET':
#         json_data = open(mockdir+'/../json/yeepay_pay_clear_data.json')
#         return jsonify(json.load(json_data))

# ***
# *** *** *** 15: not used in pay-center *** *** 
# *** 退货退款
# *** https://ok.yeepay.com/merchant/query_server/direct_refund
# *** HTTP 请求方式 :POST
# *** 请求参数:amount,currency,cause,merchantaccount,orderid,origyborderid,sign
# ***
# @app.route("/merchant/query_server/direct_refund", methods=['POST'])
# @crossdomain(origin='*')
# def direct_refund():
#     if request.method == 'POST':
#         json_data = open(mockdir+'/../json/yeepay_direct_refund.json')
#         return jsonify(json.load(json_data))

# ***
# *** *** *** 16: not used in pay-center *** *** 
# *** 退货退款记录查询
# *** https://ok.yeepay.com/merchant/query_server/refund_single
# *** HTTP 请求方式:GET
# *** 请求参数:merchantaccount,orderid,yborderid,sign
# ***
# @app.route("/merchant/query_server/refund_single", methods=['GET'])
# @crossdomain(origin='*')
# def refund_single():
#     if request.method == 'GET':
#         json_data = open(mockdir+'/../json/yeepay_refund_single.json')
#         return jsonify(json.load(json_data))

# ***
# *** *** *** 17: not used in pay-center *** *** 
# *** 获取退款清算对账记录
# *** ttps://ok.yeepay.com/merchant/query_server/refund_clear_data
# *** HTTP 请求方式:GET
# *** 请求参数:merchantaccount,startdate,enddate,sign
# ***
# @app.route("/merchant/query_server/refund_clear_data", methods=['GET'])
# @crossdomain(origin='*')
# def refund_clear_data():
#     if request.method == 'GET':
#         json_data = open(mockdir+'/../json/yeepay_refund_clear_data.json')
#         return jsonify(json.load(json_data))

if __name__ == '__main__':
    # 内部监听使用127.0.0.1
    # app.run(debug=True, host="127.0.0.1", port=9000)

    # 公开IP监听
    app.run(debug=True, host="0.0.0.0", port=9002)



