#!/bin/bash

project_path=/home/quant_group/jenkins/workspace/XyqbAndroidBuild
target_file=${project_path}/app/build.gradle
store_path=/home/ganshc/
source_gradlefile=${store_path}/build.gradle
source_flavors=${store_path}/markets.txt
buildapk_path=/home/quant_group/jenkins/workspace/XyqbAndroidBuild/build/archives
branch_name=$1
product_flavors=$2


cd ${project_path}

function get_code()
{
    if [ -z ${branch_name} ]; then
        echo "checkout default branch master"
        git pull
    else
        echo "checkout specified branch ${branch_name}"
        which git
        git checkout ${branch_name}
        if [ $? = 0 ]; then
            echo "checkout branch $1 is ok".
            git pull
        else
            echo "Fail to checkout branch ${branch_name}".
            exit -1
        fi 
    fi
}

function build_android()
{
    echo "拷贝可使用的gradle文件"
    cp -r ${source_gradlefile} ${target_file}
    if [[ -z ${product_flavors} ]]; then
        echo "${product_flavors}" > ${project_path}/markets.txt
    fi
    rm -rf ${project_path}/apk/
    echo "开始使用gradle进行编译该版本的代码"
    gradle clean resguard  --stacktrace --debug
    if [ $? = 0 ]; then
            echo "gradle build is ok".
            echo "开始重命名对应的渠道包"
            #apkfile=`find ${buildapk_path} -name "*${product_flavors}.apk"`
            apkfile=`grep "${product_flavors} *.apk"`
            echo ${apkfile}
            echo "当前路径"
            rm -rf ${project_path}/apk/*
            pwd
            mv ${buildapk_path}/${apkfile} ${project_path}/apk/${branch_name}_${product_flavors}.apk
        else
            echo "Fail to checkout branch ${branch_name}".
            exit -1
        fi 
}

function upload_apk()
{
   echo "正在将apk上传到蒲公英，请等待......"
   curl -F "file=@${project_path}/apk/${branch_name}_${product_flavors}.apk" -F "uKey=13d17385c02ea9ea994d0c985d87ff32" -F "_api_key=5b09af98d5a8ff43f2f39935fa6bfbc1" https://static.pgyer.com/app/qrcode/lJrv 
}

get_code

build_android

upload_apk

