#!/bin/bash -ilex
source /etc/profile
source ~/.bash_profile
project_path=/home/quant_group/jenkins/workspace/XyqbAndroidBuild
StroeApk_path=${project_path}/apk
BuildGradle_file=${project_path}/app/build.gradle
Constant_file=${project_path}/app/src/main/java/com/financial/quantgroup/constants/Constant.java
BuildApk_path=${project_path}/build/archives
downloadApk_path=/home/quant_group/jenkins/download_apk
SourceMarkes_flavors=/home/qa-deploy-utils/qa_shell_script/app/markets.txt
#${GIT_BRANCH} ${PRODUCT_FLAVORS} ${BUILD_TIME} ${APP_SERVER} ${APP_TYPE} ${APP_VERSION} ${NEED_UPLOAD}

git_branch=$1
product_flavors=$2
build_time=$3
test_server=$4
apk_type=$5
apk_version=$6
need_upload=$7

cd ${project_path}
function get_code()
{
    git checkout ./
    git fetch -p
    if [ -z ${git_branch} ]; then
        echo "分支为空，已切换默认分支master"
        
        git pull
    else
        echo "checkout specified branch ${git_branch}"
        git checkout -f ${git_branch}
        if [ $? = 0 ]; then
            echo "成功切换分支${git_branch}"
            git pull
        else
            echo "切换分支${git_branch}失败，请联系管理员查看".
            exit -1
        fi
    fi
}

function replace_config()
{
    if [ -f ${BuildGradle_file} ];then
        echo "正在替换配置文件，请稍后......"
        sed -i "s/apply plugin\: 'newlens'/\/\/apply plugin\: 'newlens'/g" ${BuildGradle_file}
        sed -i "s/artifact = 'com.tencent.mm:SevenZip:1.1.13'/\/\/artifact = 'com.tencent.mm:SevenZip:1.1.13'/g" ${BuildGradle_file}
        #sed -i "s/\/\/path = \"\/usr\/local\/bin\/7za\"/path = \"\/usr\/local\/p7zip_9.20.1\/bin\/7za\"/g" ${BuildGradle_file}
        sed -i "s#https://sappbackend.xyqb.com/#http://${test_server}/#g" ${Constant_file}
        
    else
        echo "${BuildGradle_file} 文件不存在，请联系管理人员查看"
        exit -1
    fi
}


function build_android()
{
    if [[ ! -z ${SourceMarkes_flavors} ]]; then
        echo "${product_flavors}" > ${project_path}/markets.txt
    else
	cp -r ${SourceMarkes_flavors} ${project_path}
        echo "构建所有渠道包"
    fi
    rm -rf ${BuildApk_path}/*
    #rm -rf ${project_path}/apk/*
    cd ${project_path}
    pwd
    echo "开始使用gradle进行编译该版本的代码"
    #gradle resguard
    echo "=================== ${GRADLE_HOME}"
    gradle clean resguardRelease
    if [ $? = 0 ]; then
        echo "成功构建APK包"
        echo "开始重命名对应的渠道包"
        cd ${BuildApk_path}
        #if [[ ! -z ${product_flavors} ]]; then
        #    ApkFile="`find ${BuildApk_path} -name "*${product_flavors}.apk"`"
        #else
        #    ApkFile="`find ${BuildApk_path} -name "*ceshi.apk"`"
        #fi
	    ApkFile=`find ${BuildApk_path} -name "*${product_flavors}*.apk"`
        echo "apk名称是：${ApkFile}"
        echo "当前路径 `pwd`"
        #mv ${ApkFile} ${StroeApk_path}/${git_branch}_${product_flavors}.apk
        mv ${ApkFile} ${git_branch}_${product_flavors}_${build_time}.apk
        cp -R ${git_branch}_${product_flavors}_${build_time}.apk ${downloadApk_path}/${apk_type}_${apk_version}.apk
    else
        echo "构建失败，请联系管理员查看".
        exit -1
    fi
}

function upload_toLocalAppStore()
{
   
    echo "apk正在本地appstore，请等待......"
    #cd ${StroeApk_path}
    echo "当前上传apk包的路径是 `pwd`"
    echo "curl -F \"file=@${git_branch}_${product_flavors}_${build_time}.apk\" -F \"type=${apk_type}\" -F \"version=${apk_version}\" http://192.168.28.141:9000/android/upload"
    curl -F "file=@${git_branch}_${product_flavors}_${build_time}.apk" -F "type=${apk_type}" -F "version=${apk_version}" http://192.168.28.141:9000/android/upload
    if [ $? != 0 ]; then
        echo "上传失败，请联系管理员查看"
    fi
    
} 

function upload_apk()
{

    if [ "$need_upload" == "true" ]; then
        echo "apk正在上传到蒲公英，请等待......"
        #cd ${StroeApk_path}
        echo "当前上传apk包的路径是 `pwd`"
        #curl -F "file=@${git_branch}_${product_flavors}_${build_time}.apk" -F "uKey=13d17385c02ea9ea994d0c985d87ff32" -F "_api_key=5b09af98d5a8ff43f2f39935fa6bfbc1" https://qiniu-storage.pgyer.com/apiv1/app/upload
        curl -F "file=@${git_branch}_${product_flavors}_${build_time}.apk" -F "uKey=41968e9da5a634b7b33dc8ff41e31c4e" -F "_api_key=8c303b6f70e8abbda50d1503568f1864" https://qiniu-storage.pgyer.com/apiv1/app/upload
        if [ $? != 0 ]; then
            echo "上传失败，请联系管理员查看"
        fi
    fi
}   

#get_code

replace_config

build_android

upload_toLocalAppStore

upload_apk

