-- MySQL dump 10.14  Distrib 5.5.60-MariaDB, for Linux (x86_64)
--
-- Host: 172.17.5.13    Database: workflow
-- ------------------------------------------------------
-- Server version 5.6.43-log

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `dec_flow_application`
--

DROP TABLE IF EXISTS `dec_flow_application`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dec_flow_application` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `app_type` tinyint(1) DEFAULT NULL COMMENT '申请类型(0：上线；1：删除)',
  `apply_user_id` int(11) DEFAULT NULL COMMENT '申请人id',
  `app_time` timestamp NULL DEFAULT NULL,
  `check_user_id` int(11) DEFAULT NULL,
  `check_time` timestamp NULL DEFAULT NULL,
  `dec_flow_detail_id` bigint(11) DEFAULT NULL,
  `check_status` tinyint(1) DEFAULT NULL COMMENT '审核结果(0：已拒绝\n\n1：已通过\n\n2：待审批\n\n3: 已撤回)',
  `app_object` tinyint(1) DEFAULT NULL COMMENT '申请对象(0：决策流；1：决策表；2：决策流分支)',
  `refusal_reason` varchar(255) DEFAULT NULL COMMENT '拒绝原因',
  `enable` tinyint(1) NOT NULL DEFAULT '1' COMMENT '0：不可用；1：可用',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `app_desc` varchar(255) DEFAULT NULL COMMENT '申请说明',
  `var_detail_id` bigint(11) DEFAULT NULL COMMENT '特征id',
  PRIMARY KEY (`id`),
  KEY `fk_dec_flow_application_detail` (`dec_flow_detail_id`),
  KEY `fk_dec_user_on_apply_user_id` (`apply_user_id`),
  KEY `fk_dec_user_on_check_user_id` (`check_user_id`),
  CONSTRAINT `fk_dec_flow_application_detail` FOREIGN KEY (`dec_flow_detail_id`) REFERENCES `dec_flow_detail` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `fk_dec_user_on_apply_user_id` FOREIGN KEY (`apply_user_id`) REFERENCES `tb_user` (`user_id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `fk_dec_user_on_check_user_id` FOREIGN KEY (`check_user_id`) REFERENCES `tb_user` (`user_id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1668 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `role_permission_mapping`
--

DROP TABLE IF EXISTS `role_permission_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `role_permission_mapping` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role_id` int(11) DEFAULT NULL,
  `permission_id` int(11) DEFAULT NULL COMMENT '权限id',
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `role_id` (`role_id`),
  KEY `permission_id` (`permission_id`),
  CONSTRAINT `role_permission_mapping_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `tb_role` (`role_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `role_permission_mapping_ibfk_2` FOREIGN KEY (`permission_id`) REFERENCES `tb_permission` (`permission_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=221 DEFAULT CHARSET=utf8 COMMENT='角色、权限关联表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `score_card_type`
--

DROP TABLE IF EXISTS `score_card_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `score_card_type` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `sct_name` varchar(32) DEFAULT NULL COMMENT '类别名称',
  `sct_total_score` int(11) NOT NULL DEFAULT '0' COMMENT '类别总评分',
  `enable` tinyint(1) NOT NULL DEFAULT '1' COMMENT '0-不可用，1-可用',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `score_card_id` bigint(11) DEFAULT NULL COMMENT '类别所属评分卡id',
  `var_detail_id` bigint(11) DEFAULT NULL COMMENT '类别对应特征id',
  PRIMARY KEY (`id`),
  KEY `fk_sct_var_detail_1` (`score_card_id`),
  KEY `fk_sct_var_detail_2` (`var_detail_id`),
  CONSTRAINT `fk_sct_var_detail_1` FOREIGN KEY (`score_card_id`) REFERENCES `var_detail` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `fk_sct_var_detail_2` FOREIGN KEY (`var_detail_id`) REFERENCES `var_detail` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `score_card_type_detail`
--

DROP TABLE IF EXISTS `score_card_type_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `score_card_type_detail` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `sct_characteristic_type` tinyint(1) DEFAULT NULL COMMENT '特征类型(0：枚举；1：范围；2：其它)',
  `sct_characteristic_rule` varchar(255) DEFAULT NULL COMMENT '特征规则',
  `sct_score` int(11) NOT NULL DEFAULT '0' COMMENT '对应分数',
  `enable` tinyint(1) NOT NULL DEFAULT '1' COMMENT '0-不可用，1-可用',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `sct_id` bigint(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `detail_sct_ibfk_1` (`sct_id`),
  CONSTRAINT `detail_sct_ibfk_1` FOREIGN KEY (`sct_id`) REFERENCES `score_card_type` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_role_mapping`
--

DROP TABLE IF EXISTS `user_role_mapping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_role_mapping` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `role_id` int(11) DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `role_id` (`role_id`),
  CONSTRAINT `user_role_mapping_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `tb_user` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `user_role_mapping_ibfk_2` FOREIGN KEY (`role_id`) REFERENCES `tb_role` (`role_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=201 DEFAULT CHARSET=utf8 COMMENT='量子魔方系统登录权限表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `var_detail`
--

DROP TABLE IF EXISTS `var_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `var_detail` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `var_type` varchar(10) NOT NULL,
  `var_title` varchar(128) NOT NULL,
  `var_name` varchar(128) NOT NULL,
  `enable` tinyint(1) DEFAULT '1' COMMENT '0-不可用，1-可用',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `var_character_type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '特征类型(0：基础特征；1：普通衍生特征；2：评分卡衍生特征)',
  `var_remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `var_group_id` bigint(11) DEFAULT NULL COMMENT '特征组id',
  `var_no` varchar(32) DEFAULT NULL COMMENT '评分卡编号',
  `var_rule` text COMMENT '衍生特征规则',
  `created_by` varchar(30) DEFAULT NULL,
  `updated_by` varchar(30) DEFAULT NULL,
  `related_var_names` text COMMENT '衍生特征规则所关联的名称',
  `is_disable` tinyint(1) DEFAULT '0' COMMENT '是否禁用(0：禁用，1：启用)',
  `application_status` tinyint(1) DEFAULT '0' COMMENT '申请状态(0：已同意;1：待审批;2：已拒绝)',
  PRIMARY KEY (`id`),
  KEY `detail_group_ibfk_1` (`var_group_id`),
  CONSTRAINT `detail_group_ibfk_1` FOREIGN KEY (`var_group_id`) REFERENCES `var_group` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=851 DEFAULT CHARSET=utf8 COMMENT='变量详情表';
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2019-12-24 16:18:41