# -------------------------------------------------------------------------------
# Filename:    java_deploy.sh
# Revision:    1.0
# Date:        2016/09
# Author:      Xiaolin.zhu
# Description: 该脚本负责build UI项目。
# Usage：used by ../deploy/ui_deploy.sh
# -------------------------------------------------------------------------------
source ~/.bash_profile

module_name=$1
npm_install=$2
ui_sys_type=$3
bower_install=false
build_cmd="npm run build"
conf_file=src/js/config.env.js

# xyqb-ui do bower install --allow-root 需要手动选择版本号
# 所有的“系统”，如：谛听，财务等，都需要bower install
if [[ "${ui_sys_type}" = "management_sys" ]]; then
     bower_install=true
    if [[ "${module_name}" = "di-ting-ui" ]]; then
        conf_file=client/app/config.js
        build_cmd="grunt build"
    else
        conf_file=src/js/env.config.js
        build_cmd="npm run build"
    fi
elif [[ "${ui_sys_type}" = "business_sys" ]]; then
    if [[ "${module_name}" = "xyqb-ui" ]]; then
        bower_install=true
        conf_file=client/app/config.js
        build_cmd="grunt build"
    elif [[ "${module_name}" = "qgbc-ui" ]]; then
        bower_install=false
        conf_file=src/app/config/env.config.js
        build_cmd="npm run build_production"
    elif [[ "${module_name}" = "spider-center-ui" ]]; then
        bower_install=false
        conf_file=src/app/config/env.config.js
        build_cmd="npm run qa"
    elif [[ "${module_name}" = "xyqb-user-ui" ]]; then
        bower_install=false
        conf_file=src/app/config.js
        build_cmd="npm run qa"
    elif [[ "${module_name}" = "activity-ui" ]]; then
        # vue2.0 will use the same config of activity-ui
        bower_install=false
        conf_file=src/app/config.js
        build_cmd="npm run build"
    else
        bower_install=false
        conf_file=src/app/config/env.config.js
        build_cmd="npm run build"
    fi
else
    echo "Error! Please config ui_sys_type: business_sys or management_sys."
fi

echo "module_name is ${module_name}"
ts=`date +%s`
echo "curl http://oeazjz3gi.bkt.clouddn.com/qa.${module_name}.config.js?random=${ts} -o new.config.js"
curl http://oeazjz3gi.bkt.clouddn.com/qa.${module_name}.config.js?random=${ts} -o new.config.js
if [ $? = 0 ]; then
    echo "get config file is ok."
else
    echo "Error: Fail to get config file."
    exit -1
fi 

mv -f new.config.js $conf_file

if [ "$npm_install" = true ]; then
    echo "npm_install is ${npm_install}"

    npm install
    if [ $? = 0 ]; then
        echo npm package ok!
    else
        echo npm package have something wrong !!!!!!!!
    	exit -1
	fi

    if [[ "$bower_install" = true ]]; then
        echo "bower_install is ${bower_install}"
        bower -v
        bower install --allow-root
    fi
else
    echo "skip npm install"
fi

echo "use $build_cmd to build ui"
$build_cmd


echo "Create tgz package"
tar cfz ./${module_name}_dist.tar.gz ./dist
if [ $? = 0 ]; then
    echo "tar package ok!"
else
    echo "Error: fail to tar package."
    exit -1
fi


echo "mkdir -p /home/quant_group/deploy_backup"
mkdir -p /home/quant_group/deploy_backup
echo "rm -f /home/quant_group/deploy_backup/${module_name}_dist.tar.gz"
rm -f /home/quant_group/deploy_backup/${module_name}_dist.tar.gz
echo "cp ${module_name}_dist.tar.gz /home/quant_group/deploy_backup/"
cp ${module_name}_dist.tar.gz /home/quant_group/deploy_backup/
exit $?
