#!/bin/sh
source ~/.bash_profile
module_name=$1
worker_host=$2
re_load_config=$3

echo "[params] module_name: $1, worker_host: $2, re_load_config: $3"

utils_path="/home/quant_group/qa-deploy-utils"

basic_no=$((${worker_host:10}))
mysql_no=$((${worker_host:10}))

mkdir -p /home/quant_group/remote_backup/${module_name}
rm -rf /home/quant_group/remote_backup/${module_name}
tar -zxvf /home/quant_group/remote_backup/${module_name}.tar.gz  -C /home/quant_group/remote_backup
mkdir -p /home/quant_group/${module_name}
rm -rf /home/quant_group/${module_name}
mv /home/quant_group/remote_backup/${module_name} /home/quant_group/

cd /home/quant_group/${module_name}/
ts=`date +%s`

if [ ${module_name} = "AppBackend" ]; then
	sourceConfigFile=qa.${module_name}.config.js
	targetConfigFile=config/environment/test.js
	restartCmd="sh /home/quant_group/${module_name}/test.sh"
elif [ ${module_name} = "activity-op" ]; then
	sourceConfigFile=qa.${module_name}.config.js
	targetConfigFile=src/config.js
	echo "sh /home/quant_group/${module_name}/stop.sh"
	sh /home/quant_group/${module_name}/stop.sh 
	echo "npm install"
	npm install
	restartCmd="sh /home/quant_group/${module_name}/start.sh"
elif [ ${module_name} = "qin-qiong" ]; then
	echo "sh ${utils_path}/sh-utils/worker/process_stop.sh python port=7022"
	sh ${utils_path}/sh-utils/worker/process_stop.sh "python" "port=7022"
	sleep 5

	python /home/quant_group/${module_name}/setup.py install

	echo "#!/bin/sh" > start.sh
	echo "python /home/quant_group/${module_name}/run.py --mode=beta --port=7022 > /dev/null 2>&1 &" >> start.sh

	sourceConfigFile=qa.${module_name}.config.properties
	targetConfigFile=config/beta/config.properties
	restartCmd="sh /home/quant_group/${module_name}/start.sh"
	# restartCmd="python /home/quant_group/qin-qiong/run.py --mode=beta --port=7022 > /dev/null 2>&1 &"
elif [ ${module_name} = "xyqb-query" ]; then
	echo  "sh ${utils_path}/sh-utils/worker/process_stop.sh python port=7033"
	sh ${utils_path}/sh-utils/worker/process_stop.sh "python" "port=7033"
	sleep 5
	python /home/quant_group/${module_name}/server/setup.py install
	
	echo "#!/bin/sh" > start.qa.sh
	echo "python /home/quant_group/${module_name}/server/run.py --mode=beta --port=7033 > /dev/null 2>&1 &" >> start.qa.sh

	sourceConfigFile=qa.${module_name}.config.ini
	targetConfigFile=server/config/beta/config.ini
	restartCmd="sh /home/quant_group/${module_name}/start.qa.sh"
elif [ ${module_name} = "op-api" ]; then
	sourceConfigFile=qa.${module_name}.config.js
	targetConfigFile=src/config.js
	echo "sh /home/quant_group/${module_name}/stop.sh"
	sh /home/quant_group/${module_name}/stop.sh 
	echo "npm install"
	npm install
	restartCmd="sh /home/quant_group/${module_name}/start.sh"
else
	echo "currently only AppBackend, qin-qiong, and xyqb-query, op-api, activity-op are supported by this script"
fi

 if [[ "${re_load_config}" = true ]]; then
	echo "Step 1: get config from qiqiu"
	echo "curl http://oeazjz3gi.bkt.clouddn.com/${sourceConfigFile}?random=${ts} -o new.config"
	curl http://oeazjz3gi.bkt.clouddn.com/${sourceConfigFile}?random=${ts} -o new.config
	mv -f new.config $targetConfigFile
 else
 	echo "Step 1: Skip reload config"
 fi

echo "Step 2: replace ip"
sed -i "s/192.168.4.3/${worker_host}/g" $targetConfigFile
sed -i "s/192.168.4.4/192.168.4.${basic_no}/g" $targetConfigFile
sed -i "s/192.168.4.5/192.168.4.${mysql_no}/g" $targetConfigFile

echo "Step 3: restart"
echo $restartCmd
$restartCmd
