#!/bin/bash
pwd_path="/home/qa-deploy-utils/qa_shell_script"
config_shell_path="$pwd_path"
config_server="$pwd_path/config_server"
frp_file_path="/home/quant_group/frp_0.12.0_linux_amd64"
filename="$frp_file_path/frpc_custom_new_1.ini"
nginxname="/usr/local/openresty/nginx/conf/conf.d"
pwd_path_0="/home/qa-deploy-utils"
 
dockernamespace=`cat $pwd_path/ngrok/docker_env_name.sh` 
ips=`cat $config_server/get_env_ip.sh`
rm -rf $filename
function addFrpcHead()
{
	echo "[common]" >> $1
	echo "server_addr = 127.0.0.1" >> $1
	echo "server_port = 7000" >> $1
	echo "privilege_token = 12345678" >> $1
	echo "log_file = ./frpc.log" >> $1
	echo "log_level = info" >> $1
	echo "log_max_days = 3" >> $1
	echo "" >> $1
}
addFrpcHead $filename

function addFrpcSub()
{
	sub_domain=$1
	sub_type=$2
	sub_ip_first=$3
	sub_ip_last=$4
	sub_port=$5
	sub_custom_domain=${6,,}
	sub_file=$7
	
	echo "" >>$sub_file
	echo "[$sub_domain-$sub_custom_domain]" >> $sub_file
	echo "type = $sub_type" >> $sub_file
	echo "local_ip = $sub_ip_first.$sub_ip_last" >> $sub_file
	echo "local_port = $sub_port" >> $sub_file
	echo "subdomain = $sub_custom_domain" >> $sub_file
}
function addFrpcLoc()
{
	sub_domain=$1
	sub_type=$2
	sub_port=$3
	cus_domain=${4,,}
	sub_loc=$5
	sub_file=$6
	
	echo "" >> $sub_file
	echo "[$sub_domain]" >> $sub_file
	echo "type = $sub_type" >> $sub_file
	echo "local_port = $sub_port" >> $sub_file
	echo "custom_domains = $cus_domain" >> $sub_file
	echo "locations = $sub_loc" >> $sub_file
}

addFrpcLoc local_ http 8000 q-gp.com / $filename


addFrpcSub store http 127.0.0 1 8001 store  $filename
addFrpcSub h5 http 192.168.4 25 7051 h5 $filename
addFrpcSub mock http 192.168.4 27 80 mock $filename
addFrpcSub atm http 192.168.4 18 3000 atm $filename
addFrpcSub auth-center http 192.168.4 193 8099 auth-center-38 $filename
addFrpcSub company http 192.168.4 27 10087 company-241 $filename
addFrpcSub bp http 192.168.4 27 10084 bp $filename
addFrpcSub qahelp http 192.168.4 27 8000 qahelp $filename
addFrpcSub h5sp http 192.168.4 25 7057  h5sp-25 $filename
addFrpcSub qg1 http 192.168.4 21 9019 qg1-21 $filename
addFrpcSub uanguang http 192.168.4 124 80 uanguang $filename


function createNginxSSLConf()
{
	cus_domain=$1
	cus_ip=$2
	cus_port=$3
	file_name=$4
	
	rm -rf $file_name
	touch $file_name
	
	echo "server {" >> $file_name
	echo "    listen       443 ssl;" >> $file_name
	echo "    server_name  $cus_domain.q-gp.com;" >> $file_name
	echo "" >> $file_name
	echo "    ssl_certificate      /home/q-gp/ssl/certificate.crt;" >> $file_name
	echo "    ssl_certificate_key  /home/q-gp/ssl/private.key;" >> $file_name
	echo "" >> $file_name
	echo "    ssl_session_cache    shared:SSL:1m;" >> $file_name
	echo "    ssl_session_timeout  5m;" >> $file_name
	echo "" >> $file_name
	echo "    ssl_ciphers  HIGH:!aNULL:!MD5;" >> $file_name
	echo "    ssl_prefer_server_ciphers  on;" >> $file_name
	echo "" >> $file_name
	echo "    location / {" >> $file_name
	echo "        proxy_pass http://$cus_ip:$cus_port;" >> $file_name
	echo "    }" >> $file_name
	echo "}" >> $file_name
	
}

function createNginxHttpAndSSLConf()
{
	cus_domain=$1
	cus_ip=$2
	cus_port=$3
	file_name=$4
	
	rm -rf $file_name
	touch $file_name
	
	echo "server {" >> $file_name
	echo "    listen 8000;" >> $file_name
	echo "    server_name  $cus_domain.q-gp.com;" >> $file_name
	echo "    proxy_set_header Host  \$host;"  >> $file_name
	echo "" >> $file_name
	echo "    location / {" >> $file_name
	echo "        proxy_pass http://$cus_ip:$cus_port;" >> $file_name
	echo "    }" >> $file_name
	echo "}" >> $file_name
	echo "" >> $file_name
	echo "server {" >> $file_name
	echo "    listen       443 ssl;" >> $file_name
	echo "    server_name  $cus_domain.q-gp.com;" >> $file_name
	echo "" >> $file_name
	echo "    ssl_certificate      /home/q-gp/ssl/certificate.crt;" >> $file_name
	echo "    ssl_certificate_key  /home/q-gp/ssl/private.key;" >> $file_name
	echo "" >> $file_name
	echo "    ssl_session_cache    shared:SSL:1m;" >> $file_name
	echo "    ssl_session_timeout  5m;" >> $file_name
	echo "" >> $file_name
	echo "    ssl_ciphers  HIGH:!aNULL:!MD5;" >> $file_name
	echo "    ssl_prefer_server_ciphers  on;" >> $file_name
	echo "    proxy_set_header Host  \$host;"  >> $file_name
	echo "" >> $file_name
	echo "    location / {" >> $file_name
	echo "        proxy_pass http://$cus_ip;" >> $file_name
	echo "    }" >> $file_name
	echo "}" >> $file_name
	
}



rm -rf $nginxname/*
createNginxSSLConf store 192.168.4.27 9000 $nginxname/store.conf

for ip_last in ${ips[@]}
do
	IP_host=`sh $pwd_path_0/get-ip.sh $ip_last`
	ip_arr=(${IP_host//./ })
	ipfirst="${ip_arr[0]}.${ip_arr[1]}.${ip_arr[2]}"
	iplast="${ip_arr[3]}"
	projectAndPorts=`node $config_server/get_project_config.js  -type multi -attr port -attr2 true`
	for projectAndPort in ${projectAndPorts[@]}
	do
		var=(${projectAndPort//|/ })
		ip_last_repeat=${ip_last//./-}  	
		addFrpcSub ${var[0]} http $ipfirst $iplast ${var[1]} ${var[0]}-${ip_last_repeat} $filename
		createNginxSSLConf ${var[0]}-${ip_last} $ipfirst.$iplast ${var[1]} $nginxname/${var[0]}-${ip_last}.conf
	done
done 

for host_name in ${dockernamespace[@]}
do 
	projectAndPorts=`node $config_server/get_project_config.js  -type multi -attr port/url -attr2 true`
	for projectAndPort in ${projectAndPorts[@]}
	do
		var=(${projectAndPort//|/ })
		namespace=(${host_name//|/ })
		if [[ ${var[0]} != "xyqb-ui" ]] && [[  ${var[0]} != "paycenter-ui"  ]];then
			addFrpcSub ${var[0]}-${var[2]} http 127.0.0 1 8000 ${var[2]}-${namespace[0]} $filename
			createNginxHttpAndSSLConf ${var[2]}-${namespace[0]} ${namespace[1]} ${namespace[2]} $nginxname/${var[0]}-${namespace[0]}.conf
		fi
	done	
	basePorts="redis|80 db|3306 rabbitmq|80"
	for basePort in ${basePorts[@]} 
	do
		var=(${basePort//|/ })
		namespace=(${host_name//|/ })
		ips=(${namespace[1]//./ })
		addFrpcSub ${var[0]}-${var[2]} http ${ips[0]}.${ips[1]}.${ips[2]} ${ips[3]} ${var[1]} ${var[0]}-${namespace[0]} $filename
	done 
done

nginx -s reload
sh ${frp_file_path}/restart.sh
