#!/bin/bash
project=$1
config_server=$2
project_path=$3

params=`node $config_server/get_project_config.js  -name $project -attr desc/target_path/command2`
params_arry=(${params//|/ })
desc=${params_arry[0]}
target_path=${params_arry[1]}
build_command=${params_arry[2]//\^/ }
sh $config_server/show_info.sh $project BUILD $desc `hostname`
cd $project_path/$project

rm -rf $target_path
rm -rf $project.jar

echo "准备修改pom文件中的消息中心SDK测试版本"
nums=(`awk '/quantgroup-sms-sdk/ {print NR}' $project_path/$project/pom.xml`)
for num in ${nums[@]}
do
	lin=$[ $num+1 ]
	echo "第$lin行 pom文件修改成<version>2.0.0.3-SNAPSHOT</version>"
	sed -i "${lin}s/version.*-S.*</version>2.0.0.3-SNAPSHOT</"  $project_path/$project/pom.xml
done
echo "修改完毕"

echo "$build_command"

$build_command
if [ $? = 0 ]; then
	echo "${project} build ok"
else
	echo "${project} build fail"
	exit -1
fi
echo "$target_path"
mv $project_path/$project/$target_path/*.jar $project_path/$project/$project.jar