# -------------------------------------------------------------------------------
# Filename:    java_deploy.sh
# Revision:    1.0
# Date:        2016/09
# Author:      Xiaolin.zhu
# Description: 该脚本远程copy ui，js， 和java项目。
# Usage：used by ../deploy/＊_deploy.sh
# -------------------------------------------------------------------------------
module_name=$1
target_host=$2
module_type=$3

if [[ "${module_name}" = "han-gu-guan" ]]
then 
	package_name="xyqb-openauth-0.0.1-SNAPSHOT.jar"
elif [[ "${module_name}" = "di-ting" ]]
then 
	package_name="xyqb-di_ting-0.0.1-SNAPSHOT.jar"
elif [[ "${module_name}" = "jian-men-guan" ]]
then 
	package_name="risk-control-auth-1.0-SNAPSHOT.jar"
elif [[ "${module_name}" = "du-jiang-yan" ]]
then 
	package_name="du-jiang-yan-1.0-SNAPSHOT.jar"
elif [[ "${module_name}" = "financial-system" ]]
then 
	package_name="xyqb-financial_system-0.0.1-SNAPSHOT.jar"
elif [[ "${module_name}" = "mall" ]]
then 
	package_name="xyqb-mall-0.0.1-SNAPSHOT.jar"
elif [[ "${module_name}" = "quartz" ]]
then 
	package_name="xyqb-quartz-0.0.1-SNAPSHOT.jar"
elif [[ "${module_name}" = "xyqb-user" ]]
then 
	package_name="xyqb-user2-0.0.1-SNAPSHOT.jar"
elif [[ "${module_name}" = "red-packet" ]]
then 
	package_name="redpacket-0.0.1-SNAPSHOT.jar"
else
	if [[ "${module_type}" = "java" ]]
	then
		package_name="${module_name}-0.0.1-SNAPSHOT.jar"
	elif [[ "${module_type}" = "ui" ]]
	then
		package_name="${module_name}_dist.tar.gz"
	else
		echo "ERROR: module type: ${module_type} does not exist!"
		exit -1
	fi
fi

echo "copy module: ${package_name} to host: $target_host"
scp /home/quant_group/deploy_backup/${package_name} root@${target_host}:/home/quant_group/deploy_backup/
echo "ssh root@${target_host} mkdir -p /home/quant_group/${module_name}"
ssh root@${target_host} mkdir -p /home/quant_group/${module_name}
echo "ssh root@${target_host} cp /home/quant_group/deploy_backup/${package_name} /home/quant_group/${module_name}/"
ssh root@${target_host} cp /home/quant_group/deploy_backup/${package_name} /home/quant_group/${module_name}/
