#!/bin/bash
ip=$1
orderId=$2  #mall订单号

len=`echo $orderId |awk '{print length}'`
if [ -z $len ]
then
        echo "请输入订单号"
        exit -1  #exit命令同于退出shell，状态值0代表执行成功，其它值代表执行失败
fi

seq=`date "+%Y-%m-%d %H:%M:%S"`
mysqld="-h$ip -p3306 -uqa -pqatest"

# 更新mall.mall_order表的订单状态为3
mysql -N $mysqld mall -e "update mall_order set order_state='3' where order_id='$orderId'";

# 更新mall.digital_order_detail表的物流信息
mallOrderId=`mysql -N $mysqld mall -e "select id from mall_order where order_id='$orderId'"`;
mysql -N $mysqld mall -e "update digital_order_detail set logistics_company='韵达',logistics_phone='18800001111',
logistics_delivery_code='1234567890',logistics_delivery_time='$seq' where order_id='$mallOrderId'";

# 更新merchant.supplier_order表的订单状态
mysql -N $mysqld merchant -e "update supplier_order set order_status='1',updated_at='$seq' where mall_order_no='$orderId'";

# 更新merchant.supplier_order_status_history表的操作记录
supplierOrderId=`mysql -N $mysqld merchant -e "select id from supplier_order where mall_order_no='$orderId'"`;
mysql -N $mysqld merchant -e "insert into supplier_order_status_history 
( supplier_order_id, status, operator, created_at, updated_at) 
values 
( '$supplierOrderId', '1', '38', '$seq', '$seq')";

# 更新merchant.supplier_order_logistics表的物流信息
orderStatusId=`mysql -N $mysqld merchant -e "select id from supplier_order_status_history where supplier_order_id='$supplierOrderId'"`;
mysql -N $mysqld merchant -e "insert into supplier_order_logistics
( order_id, order_status_id, mall_order_no, operator, created_at, updated_at, logistics_order_no, express_company, express_phone, delivery_at) 
values
( '$supplierOrderId', '$orderStatusId', '$orderId', '38', '$seq', '$seq',  '789211463752', '韵达', '18800001111', '$seq')";


echo "mall.mall_order表的订单状态已改"
echo "mall.digital_order_detail表的物流信息已更新"
echo "merchant.supplier_order表的订单状态已更新"
echo "merchant.supplier_order_status_history表的操作记录已更新"
echo "merchant.supplier_order_logistics表的物流信息已更新"

