#!/bin/bash
pwd_path="/home/qa-deploy-utils/qa_shell_script"
config_shell_path="$pwd_path"
config_server="$pwd_path/config_server"
filename=/home/quant_group/frp_0.12.0_linux_amd64/frpc_custom_new_1.ini
nginxname=/usr/local/openresty/nginx/conf/nginx_new.conf
IP_host_first="192.168.4."
ips=`cat $config_server/get_env_ip.sh`
rm -rf $filename
function addFileHead()
{
	rm -rf $1
	echo "[common]" >> $1
	echo "server_addr = 127.0.0.1" >> $1
	echo "server_port = 7000" >> $1
	echo "privilege_token = 12345678" >> $1
	echo "log_file = ./frpc.log" >> $1
	echo "log_level = info" >> $1
	echo "log_max_days = 3" >> $1
	echo "" >> $1
	echo "[atm]" >> $1
	echo "type = http" >> $1
	echo "local_ip = 192.168.4.18" >> $1
	echo "local_port = 3000" >> $1
	echo "subdomain = atm" >> $1
	echo "" >> $1
	echo "[qg-mock]" >> $1
	echo "type = http" >> $1
	echo "local_ip = 172.30.199.2" >> $1
	echo "local_port = 8080" >> $1
	echo "subdomain = mock" >> $1
	echo "" >> $1
	echo "[store]" >> $1
	echo "type = http" >> $1
	echo "local_ip = 172.30.199.2" >> $1
	echo "local_port = 9000" >> $1
	echo "subdomain = store" >> $1
	echo "" >> $1
	echo "[h5]" >> $1
	echo "type = http" >> $1
	echo "local_ip = 192.168.4.15" >> $1
	echo "local_port = 7051" >> $1
	echo "subdomain = h5" >> $1
	echo "" >> $1
	echo "[local]" >> $1
	echo "type = http" >> $1
	echo "local_port = 8000" >> $1
	echo "custom_domains = q-gp.com" >> $1
	echo "locations = /" >> $1
	echo "" >> $1
	echo "" >> $1
	echo "[localhttps]" >> $1
	echo "type = https" >> $1
	echo "local_port = 8001" >> $1
	echo "custom_domains = q-gp.com" >> $1
	echo "locations = /" >> $1
	echo " [app-241]" >> $1
	echo "type=http" >> $1
	echo "local_ip=192.168.4.241" >> $1
	echo "local_port=10087" >> $1
	echo "subdomain=app-241" >> $1
	echo "" >> $1
	echo "[auth-center-193]" >> $1
	echo "type = http" >> $1
	echo "local_ip = 192.168.4.193" >> $1
	echo "local_port = 8099" >> $1
	echo "subdomain = auth-center-38" >> $1
}

addFileHead $filename

function addFile2()
{
        echo "$1 $2 $3 $4"
        echo "[web-$2-$1-http]" >> $4
        echo "type = http" >> $4
        echo "local_ip = 192.168.4.$1" >> $4
        echo "local_port = 1$3" >> $4
        echo "subdomain = $2" >> $4
        echo "[web-$2-$1-https]" >> $4
        echo "type = https" >> $4
        echo "local_ip = 192.168.4.$1" >> $4
        echo "local_port = 2$3" >> $4
        echo "subdomain = $2" >> $4
}


#projectAndPort=`node $config_server/get_project_config.js  -type multi -attr port`
#for projectAndPort in ${projectAndPort[@]}
#do
#	var=${projectAndPort//|/ }
#	addFile2 25 $var $filename
#done

function addFile()
{
	echo "$1 $2 $3 $4"
	echo "[web-$2-$1]" >> $4
	echo "type = http" >> $4
	echo "local_ip = 192.168.4.$1" >> $4
	echo "local_port = $3" >> $4
	echo "subdomain = $2-$1" >> $4
}

function createNginxSSLConf()
{

}
# projectAndPort=`node $config_server/get_project_config.js  -type multi -attr port`


for ip_last in ${ips[@]}
do
	projectAndPort=`node $config_server/get_project_config.js  -type multi -attr port`
	for projectAndPort in ${projectAndPort[@]}
	do
		var=${projectAndPort//|/ }
		addFile $ip_last $var $filename
	done
done 




