#!/bin/bash
pwd_path="/home/qa-deploy-utils/qa_shell_script"
config_shell_path="$pwd_path"
config_server="$pwd_path/config_server"

nginxname="/usr/local/openresty/nginx/conf/conf.d"
pwd_path_0="/home/qa-deploy-utils"

dockernamespace=`cat $pwd_path/ngrok/docker_env_name.sh` 
ips=`cat $config_server/get_env_ip.sh`
rm -rf $filename

rm -rf $nginxname/*


function createNginxHttpAndSSLConf()
{
	project_name=$1
	cus_domain=$2
	cus_ip=$3
	http_port=$4
	https_port=$5
	file_name=$6
	echo "$project_name"
	touch $file_name
	echo "############----${project_name}----############" >> $file_name
	echo "server {" >> $file_name
	echo "    listen 80;" >> $file_name
	echo "    server_name  $cus_domain.q-gp.com;" >> $file_name
	echo "    	underscores_in_headers on;" >> $file_name

	echo "    proxy_set_header Host  \$host;"  >> $file_name
	echo "    proxy_set_header QT_TOKEN  \$http_QT_TOKEN;"  >> $file_name

	echo "" >> $file_name
	echo "    location / {" >> $file_name
	echo "        proxy_pass http://$cus_ip:$http_port;" >> $file_name
	echo "    }" >> $file_name
	echo "}" >> $file_name
	echo "" >> $file_name
	echo "server {" >> $file_name
	echo "    listen       443 ssl;" >> $file_name
	echo "    server_name  $cus_domain.q-gp.com;" >> $file_name
	echo "" >> $file_name
	echo "    proxy_set_header QT_TOKEN  \$http_QT_TOKEN;"  >> $file_name
	echo "    ssl_certificate      /home/q-gp/ssl/certificate.crt;" >> $file_name
	echo "    ssl_certificate_key  /home/q-gp/ssl/private.key;" >> $file_name
	echo "" >> $file_name
	echo "    ssl_session_cache    shared:SSL:1m;" >> $file_name
	echo "    ssl_session_timeout  5m;" >> $file_name
	echo "" >> $file_name
	echo "    ssl_ciphers  HIGH:!aNULL:!MD5;" >> $file_name
	echo "    ssl_prefer_server_ciphers  on;" >> $file_name
	echo "    proxy_set_header Host  \$host;"  >> $file_name
	echo "" >> $file_name
	echo "    location / {" >> $file_name
	echo "        proxy_pass http://$cus_ip:$https_port;" >> $file_name
	echo "    }" >> $file_name
	echo "}" >> $file_name
	
}

# 数据部要求地址
createNginxHttpAndSSLConf auth-center auth-center-38 192.168.4.193 8099 8099 $nginxname/base.conf
createNginxHttpAndSSLConf h5sp h5sp-25 192.168.4.25 7057 7057 $nginxname/base.conf


# 业务要求
createNginxHttpAndSSLConf h5 h5 192.168.4.26 7051 7051 $nginxname/base.conf
createNginxHttpAndSSLConf qg1 qg1-21 192.168.4.21 9019 9019 $nginxname/base.conf
createNginxHttpAndSSLConf uanguang uanguang 192.168.4.124 80 80 $nginxname/base.conf
createNginxHttpAndSSLConf gongyucheng gongyucheng 192.168.4.254 80 80 $nginxname/base.conf

# 工作目录
createNginxHttpAndSSLConf jen jen 192.168.4.2 8080 8080 $nginxname/base.conf


# 自定义服务
createNginxHttpAndSSLConf qa qa 172.30.220.22  80 80 $nginxname/base.conf
createNginxHttpAndSSLConf qg qg 172.30.220.22 10087 10087 $nginxname/base.conf
createNginxHttpAndSSLConf bp bp 172.30.220.22 10084 10084 $nginxname/base.conf
createNginxHttpAndSSLConf qahelp qahelp 172.30.220.22 8000 8000 $nginxname/base.conf
createNginxHttpAndSSLConf store store 172.30.220.22 9000 9000 $nginxname/base.conf
createNginxHttpAndSSLConf mock mock 172.30.220.22 80 80 $nginxname/base.conf
createNginxHttpAndSSLConf atm atm 172.30.220.43 80 80 $nginxname/base.conf
createNginxHttpAndSSLConf mockapi mockapi 172.30.220.22 80 80 $nginxname/base.conf
createNginxHttpAndSSLConf acs acs 172.30.220.43 8585 8585 $nginxname/base.conf





for ip_last in ${ips[@]}
do
	IP_host=`sh $pwd_path_0/get-ip.sh $ip_last`
	ip_arr=(${IP_host//./ })
	ipfirst="${ip_arr[0]}.${ip_arr[1]}.${ip_arr[2]}"
	iplast="${ip_arr[3]}"
	ip_last_repeat=${ip_last//./-}
	projectAndPorts=`node $config_server/get_project_config.js  -type multi -attr port -attr2 true`
	for projectAndPort in ${projectAndPorts[@]}
	do
		var=(${projectAndPort//|/ })

			
		project_name="${var[0]}"
		sub_doman="${var[0]}-${ip_last_repeat}"
		target_ip="$IP_host"
		http_port="${var[1]}"
		https_port="${var[1]}"
		file_name="$nginxname/$target_ip.conf"
		# createNginxHttpAndSSLConf 服务名称 二级域名 目标IP HTTP端口  HTTPS端口 目标文件
		# if [[ ${var[0]} != "xjd-ui" ]] && [[  ${var[0]} != "new-paycenter-ui"  ]];then
			createNginxHttpAndSSLConf $project_name $sub_doman $target_ip $http_port $https_port $file_name
		# fi
	done
done 

for host_name in ${dockernamespace[@]}
do 
	projectAndPorts=`node $config_server/get_project_config.js  -type multi -attr port/url -attr2 true`
	namespace=(${host_name//|/ })

	for projectAndPort in ${projectAndPorts[@]}
	do
		var=(${projectAndPort//|/ })
		# echo "${var[2]}/${namespace[0]}/${namespace[1]}/${namespace[2]}/${namespace[3]}"
		project_name="${var[0]}"
		sub_doman="${var[2]}-${namespace[0]}"
		target_ip="${namespace[1]}"
		http_port="${namespace[2]}"
		https_port="${namespace[2]}"
		file_name="$nginxname/${namespace[0]}.conf"
   	# createNginxHttpAndSSLConf 服务名称 二级域名 目标IP HTTP端口  HTTPS端口 目标文件
		if [[ ${var[0]} != "xjd-ui" ]] && [[  ${var[0]} != "new-paycenter-ui"  ]];then
			createNginxHttpAndSSLConf $project_name $sub_doman $target_ip $http_port $https_port $file_name
		fi
	done
	# 单独增加passportapi2
	createNginxHttpAndSSLConf xyqb-user2-api2 passportapi2-${namespace[0]} ${namespace[1]} ${namespace[2]} ${namespace[2]} $nginxname/${namespace[0]}.conf
done

nginx -s reload
# sh ${frp_file_path}/restart.sh

