#!/bin/bash

project_path=/home/quant_group/jenkins/workspace/XyqbAndroidBuild
target_file=${project_path}/app/build.gradle
store_path=/home/ganshc/
source_gradlefile=${store_path}/build.gradle
source_flavors=${store_path}/markets.txt
buildapk_path=/home/quant_group/jenkins/workspace/XyqbAndroidBuild/build/archives
branch_name=$1
product_flavors=$2


cd ${project_path}

if [ -z ${branch_name} ]; then
    echo "checkout default branch master"
    git pull
else
    echo "checkout specified branch ${branch_name}"
    which git
    git checkout ${branch_name}
    if [ $? = 0 ]; then
    	echo "checkout branch $1 is ok".
        git pull
    else
    	echo "Fail to checkout branch ${branch_name}".
    	exit -1
    fi 
fi

echo "拷贝可使用的gradle文件"

cp -r ${source_gradlefile} ${target_file}

if [[ -z ${product_flavors} ]]; then
    echo "${product_flavors}" > ${project_path}/markets.txt
fi

rm -rf ${project_path}/apk/

echo "开始使用gradle进行编译该版本的代码"

gradle clean resguard  --stacktrace --debug

echo "重命名apk包名"

apkfile=`find /home/quant_group/jenkins/workspace/XyqbAndroidBuild/build/archives -name "*${product_flavors}.apk"`

cp ${apkfile} /home/quant_group/jenkins/workspace/XyqbAndroidBuild/apk/${branch_name}_${product_flavors}.apk

echo "正在将apk上传到蒲公英，请等待......"

curl -F "file=@/home/quant_group/jenkins/workspace/XyqbAndroidBuild/apk/${branch_name}_${product_flavors}.apk" -F "uKey=13d17385c02ea9ea994d0c985d87ff32" -F "_api_key=5b09af98d5a8ff43f2f39935fa6bfbc1" https://static.pgyer.com/app/qrcode/lJrv

