#!/usr/bin/env bash
# ******** the script is used when jenkins auto deploy modules ******** 
# ******** used by ../deploy/ui_deploy.sh ******** 
module_name=$1
host=$2
ui_sys_type=$3
use_public_ip=$4
public_ip="www.q-gp.com"

if [[ "${host}" = "192.168.10.2" ]]
then 
	worker_host=119.254.102.73
else
	worker_host=$host
fi

echo "rm -rf /home/quant_group/${module_name}/dist"
rm -rf /home/quant_group/${module_name}/dist

echo "tar -zxvf /home/quant_group/${module_name}/${module_name}_dist.tar.gz  -C /home/quant_group/${module_name}"
tar -zxvf /home/quant_group/${module_name}/${module_name}_dist.tar.gz  -C /home/quant_group/${module_name}

if [[ "${ui_sys_type}" = "management_sys" ]]; then
    if [[ "${module_name}" = "di-ting-ui" ]]; then
        echo "cd /home/quant_group/${module_name}/dist/public/app"
    	cd /home/quant_group/${module_name}/dist/public/app
    else
        echo "cd /home/quant_group/${module_name}/dist/js"
    	cd /home/quant_group/${module_name}/dist/js
    fi
elif [[ "${ui_sys_type}" = "business_sys" ]]; then
    if [[ "${module_name}" = "xyqb-ui" ]]; then
        echo "cd /home/quant_group/${module_name}/dist/public/app"
    	cd /home/quant_group/${module_name}/dist/public/app
    elif [[ "${module_name}" = "xyqb-user-ui" ]]; then
            echo "cd /home/quant_group/${module_name}/dist/app/js"
        	cd /home/quant_group/${module_name}/dist/app/js
    elif [[ "${module_name}" = "offline-ui" || "${module_name}" = "activity-ui" ]]; then
            echo "cd /home/quant_group/${module_name}/dist/app/js"
        	cd /home/quant_group/${module_name}/dist/app/js
    else
        echo "cd /home/quant_group/${module_name}/dist/app"
    	cd /home/quant_group/${module_name}/dist/app
    fi
else
    echo "Error! Please config ui_sys_type: business_sys or management_sys."
fi

if [[ "${use_public_ip}" = false ]]; then
    echo "use_public_ip is False: ${use_public_ip}!"
    sed -i "s/192.168.4.3/${worker_host}/g" *.js
else
    echo "use_public_ip is True: ${use_public_ip}!"
    web_no=$((${worker_host:10}))
    if [ $web_no -lt 100 ]; then
        echo "web_no < 100, ${web_no}"
        sed -i "s/192.168.4.3:7/${public_ip}:${web_no}/g" *.js
    else
        echo "web_no >= 100, ${web_no}"
        sed -i "s/192.168.4.3:70/${public_ip}:${web_no}/g" *.js
    fi
fi


