#!/usr/bin/env bash

# 切分日志，备份老运行代码
#运行示例
# sh backup.sh code_path log_path package_name module_name
function back_up()
{
    timestamp=`date +%Y%m%d-%H%M%S`
    timestamp_log=`date +%Y-%m-%d.%H%M%S`
    code_path=$1
    log_path=$2
    package_name=$3
    module_name=$4
    echo "begin backup: module name: ${module_name}, code path: ${code_path}, log path: ${log_path}, package name: ${package_name}"
    echo "timestamp: ${timestamp}, timestamplog: ${timestamplog}"
    back_up_path=/home/quant_group/ep/backup/${module_name}
    mkdir -p ${back_up_path}
    mv ${code_path} ${back_up_path}/${package_name}.${timestamp}
    mv ${log_path} ${log_path}.${timestamp_log}

}

back_up $@
exit 0