#!/bin/sh
# -------------------------------------------------------------------------------
# Filename:    db_gen_config.sh
# Revision:    1.0
# Date:        2016/12
# Author:      dekun.dai
# Description: 生成一个同步表结构用的配置文件
# -------------------------------------------------------------------------------
source ~/.bash_profile

work_dir=/home/qa-deploy-utils/db-utils
source_db_host=$1
# source_db_pwd=`grep source_db_pwd $work_dir/config/db_config | cut -d "=" -f 2`

target_db_host=$4
target_db_user=$5
target_db_pwd=$6

sync_db_name=$7
database_name=$sync_db_name

config_file_name=$8
db_backup_sub_folders=$9
use_cache=${10}
target_db_port=${11}
mkdir -p db_backup_sub_folders

port=""
sys_table_list=""

sync_config_folder=~/db_sync_configs
base_config_file=$work_dir/config/base_config.json
cache_dir=/home/quant_group/daily_db_backup

# if [ $# -ne 9 ]; then
# 	echo "db_gen_config.sh"
# 	echo "Total Number of Parameters : $#"
# 	echo "source_db_infos：source_db_host: $1, source_db_user: $2"
# 	echo "target_db_infos：target_db_host: $4, target_db_user: $5"
# 	echo "sync_db_name: $7"
# 	echo "config_file_name: $8"
# 	echo "db_backup_sub_folders: $9"
# 	exit 1
# fi

echo "prepare to get source_port"
conf=(`curl -s http://192.168.4.3:10088/config_server/get_db_config/$database_name/all`)
source_db_host=${conf[0]}
port=${conf[1]}
source_db_user=${conf[2]}
source_db_pwd=${conf[3]}
sys_table_list=${conf[@]:4}

echo "source_port is $port"
echo "copy ${base_config_file} to ${config_file_name}"
cp -f $base_config_file $config_file_name

echo "sed -i s/source_db_host/${source_db_host}/g $config_file_name"
sed -i "s/source_db_host/${source_db_host}/g" $config_file_name
sed -i "s/source_db_user/${source_db_user}/g" $config_file_name
sed -i "s/source_db_pwd/${source_db_pwd}/g" $config_file_name
sed -i "s/target_db_host/${target_db_host}/g" $config_file_name
sed -i "s/target_db_user/${target_db_user}/g" $config_file_name
sed -i "s/target_db_pwd/${target_db_pwd}/g" $config_file_name
sed -i "s/target_db_port/${target_db_port}/g" $config_file_name
sed -i "s/sync_db_name/${sync_db_name}/g" $config_file_name
sed -i "s/source_port/${port}/g" $config_file_name

#同步基础数据
if [ $use_cache = true ];then
	echo "\cp -rf $cache_dir/$database_name/. $db_backup_sub_folders/"
	\cp -rf $cache_dir/$database_name/. $db_backup_sub_folders/
else
	if [ $database_name = 'mall' ] || [ $database_name = 'quartz' ];then
		for table_name in $sys_table_list
		do
			file_name=$db_backup_sub_folders/$table_name.sql
			echo "mysqldump -u${source_db_user} -p${source_db_pwd} -h${source_db_host} -P${port} $database_name --tables $table_name --where \"1=1 order by id desc limit 1000\"> $file_name"
			mysqldump -u${source_db_user} -p${source_db_pwd} -h${source_db_host} -P${port} $database_name --skip-lock-tables --tables $table_name --where "1=1 order by id desc limit 1000" --skip-add-locks --no-create-info --complete-insert --replace > $file_name
		done
	else
		for table_name in $sys_table_list
		do
			file_name=$db_backup_sub_folders/$table_name.sql
			echo "mysqldump -u${source_db_user} -p${source_db_pwd} -h${source_db_host} -P${port} $database_name --tables $table_name > $file_name"
			mysqldump -u${source_db_user} -p${source_db_pwd} -h${source_db_host} -P${port} $database_name --skip-lock-tables --tables $table_name --skip-add-locks --no-create-info --complete-insert --replace > $file_name
		done
	fi
fi
