/*
 * Decompiled with CFR 0.152.
 */
package com.qg.saas.data.dto;

import com.qg.saas.data.dto.ResultCode;
import java.io.Serializable;

public class Result<T>
implements Serializable {
    private String code = "200";
    private String businessCode = ResultCode.SUCCESS.getCode();
    private String msg;
    private String detail;
    private T data;
    private Boolean success;
    private String traceId;

    protected void setResultCode(ResultCode resultCode) {
        this.businessCode = resultCode.getCode();
        this.msg = resultCode.getMsg();
    }

    public Result() {
    }

    public Result(String code, String businessCode, String msg, String detail, T data, boolean success) {
        this.code = code;
        this.businessCode = businessCode;
        this.msg = msg;
        this.detail = detail;
        this.data = data;
        this.success = success;
    }

    public static Result success() {
        Result<String> result = new Result<String>();
        result.setResultCode(ResultCode.SUCCESS);
        result.setData("");
        return result;
    }

    public static <T> Result<T> wrapError(String errCode, String errMsg) {
        Result<T> result = new Result<T>();
        result.setMsg(errMsg);
        result.setSuccess(false);
        result.setCode(errCode);
        result.setBusinessCode(errCode);
        result.setDetail(errMsg);
        return result;
    }

    public static <T> Result<T> supplyChainSuccess() {
        Result<T> result = new Result<T>();
        result.setCode(ResultCode.SUCCESS.getCode());
        result.setBusinessCode(ResultCode.SUCCESS.getCode());
        result.setSuccess(null);
        return result;
    }

    public static <T> Result<T> success(T data) {
        Result<T> result = new Result<T>();
        result.setResultCode(ResultCode.SUCCESS);
        result.setData(data);
        return result;
    }

    public static <T> Result<T> failure() {
        Result<T> result = new Result<T>();
        result.setResultCode(ResultCode.FAILURE);
        result.setCode(ResultCode.FAILURE.getCode());
        return result;
    }

    public static <T> Result<T> failure(T data) {
        Result<T> result = new Result<T>();
        result.setResultCode(ResultCode.FAILURE);
        result.setCode(ResultCode.FAILURE.getCode());
        result.setData(data);
        return result;
    }

    public static <T> Result<T> failure(String msg) {
        Result<T> result = new Result<T>();
        result.setBusinessCode(ResultCode.FAILURE.getCode());
        result.setCode(ResultCode.FAILURE.getCode());
        result.setMsg(msg);
        return result;
    }

    public static <T> Result<T> failure(ResultCode resultCode) {
        Result<T> result = new Result<T>();
        result.setResultCode(resultCode);
        result.setCode(ResultCode.FAILURE.getCode());
        return result;
    }

    public static <T> Result<T> failure(ResultCode resultCode, String detail) {
        Result<T> result = new Result<T>();
        result.setResultCode(resultCode);
        result.setCode(ResultCode.FAILURE.getCode());
        result.setDetail(detail);
        return result;
    }

    public boolean isSuccess() {
        return ("200".equals(this.code) || "0".equals(this.code)) && ResultCode.SUCCESS.getCode().equals(this.businessCode);
    }

    public String getCode() {
        return this.code;
    }

    public String getBusinessCode() {
        return this.businessCode;
    }

    public String getMsg() {
        return this.msg;
    }

    public String getDetail() {
        return this.detail;
    }

    public T getData() {
        return this.data;
    }

    public Boolean getSuccess() {
        return this.success;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setBusinessCode(String businessCode) {
        this.businessCode = businessCode;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result other = (Result)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$success = this.getSuccess();
        Boolean other$success = other.getSuccess();
        if (this$success == null ? other$success != null : !((Object)this$success).equals(other$success)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$businessCode = this.getBusinessCode();
        String other$businessCode = other.getBusinessCode();
        if (this$businessCode == null ? other$businessCode != null : !this$businessCode.equals(other$businessCode)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        String this$detail = this.getDetail();
        String other$detail = other.getDetail();
        if (this$detail == null ? other$detail != null : !this$detail.equals(other$detail)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$traceId = this.getTraceId();
        String other$traceId = other.getTraceId();
        return !(this$traceId == null ? other$traceId != null : !this$traceId.equals(other$traceId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Result;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $success = this.getSuccess();
        result = result * 59 + ($success == null ? 43 : ((Object)$success).hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $businessCode = this.getBusinessCode();
        result = result * 59 + ($businessCode == null ? 43 : $businessCode.hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        String $detail = this.getDetail();
        result = result * 59 + ($detail == null ? 43 : $detail.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $traceId = this.getTraceId();
        result = result * 59 + ($traceId == null ? 43 : $traceId.hashCode());
        return result;
    }

    public String toString() {
        return "Result(code=" + this.getCode() + ", businessCode=" + this.getBusinessCode() + ", msg=" + this.getMsg() + ", detail=" + this.getDetail() + ", data=" + this.getData() + ", success=" + this.getSuccess() + ", traceId=" + this.getTraceId() + ")";
    }
}

