#!/bin/bash
pwd_path="/home/qa-deploy-utils/qa_shell_script"
config_shell_path="$pwd_path"
config_server="$pwd_path/config_server"
filename=/home/quant_group/frp_0.12.0_linux_amd64/frpc_custom.ini
IP_host_first="192.168.4."
ips=`cat $config_server/get_env_ip.sh`

function addFileHead()
{
	rm -rf $1
	echo "[common]" >> $1
	echo "server_addr = 127.0.0.1" >> $1
	echo "server_port = 7000" >> $1
	echo "privilege_token = 12345678" >> $1
	echo " " >> $1
}

addFileHead $filename

function addFile()
{
	echo "$1 $2 $3 $4"
	echo "[web-$2-$1]" >> $4
	echo "type = http" >> $4
	echo "local_ip = 192.168.4.$2" >> $4
	echo "local_port = $3" >> $4
	echo "subdomain = $2-$1" >> $4
}

# projectAndPort=`node $config_server/get_project_config.js  -type multi -attr port`


for ip_last in ${ips[@]}
do
	projectAndPort=`node $config_server/get_project_config.js  -type multi -attr port`
	for projectAndPort in ${projectAndPort[@]}
	do
		var=${projectAndPort//|/ }
		addFile $ip_last $var $filename
	done
done 




