#!/bin/bash
set -u
work_dir=/home/qa-deploy-utils/db-utils
sync_config_folder=~/db_sync_configs
db_backup_folder=~/daily_db_backup

source_db_host=$1
source_db_user=$2
source_db_pwd=`grep source_db_pwd $work_dir/config/db_config | cut -d "=" -f 2`

ip_value=$4

target_db_user=$5
target_db_pwd=$6

sync_db_name=$7

function db_schema_sync()
{	
	database=$1
	uuid=$(uuidgen)
	config_file_name="$sync_config_folder/${database}_${uuid}_db_schema_sync_config.json"
	db_backup_sub_folders=$db_backup_folder/${database}
	
	echo "mkdir -p $db_backup_sub_folders"
	mkdir -p $db_backup_sub_folders
	
	echo "--- Step 1: generate_config_file: $config_file_name ---"
	echo "source infos: $source_db_host $source_db_user"
	echo "target infos: $target_db_host $target_db_user"
	echo "database_name is : $sync_db_name"

	echo "sh $work_dir/db_gen_config.sh $source_db_host $source_db_user $source_db_pwd 192.168.4.12 $target_db_user $target_db_pwd $database $config_file_name $db_backup_sub_folders false"
	sh $work_dir/db_gen_config.sh $source_db_host $source_db_user $source_db_pwd 192.168.4.12 $target_db_user $target_db_pwd $database $config_file_name $db_backup_sub_folders false
}

database_list=`grep database_list $work_dir/config/db_config | cut -d "=" -f 2`
echo "database_list:${database_list}"

for db_name in $database_list
do
	echo "----------------------------------------------------"
	echo "--- start sync $db_name ---"
	db_schema_sync $db_name
	echo "--- end sync $db_name ---"
done
echo "----------------------------------------------------"