#!/bin/bash

project_path=/home/quant_group/jenkins/workspace/XyqbAndroidBuild
target_file=${project_path}/app/build.gradle
store_path=/home/ganshc/
source_file=${store_path}/build.gradle
buildapk_path=/home/quant_group/jenkins/workspace/XyqbAndroidBuild/build/archives
branch_name=$1
product_flavors=$2


cd ${project_path}

if [ -z ${branch_name} ]; then
    echo "checkout default branch master"
    git pull
else
    echo "checkout specified branch ${branch_name}"
    which git
    git checkout ${branch_name}
    if [ $? = 0 ]; then
    	echo "checkout branch $1 is ok".
        git pull
    else
    	echo "Fail to checkout branch ${branch_name}".
    	exit -1
    fi 
fi

echo "copy file to app"

cp -r ${source_file} ${target_file}

echo "gradle build start"

gradle clean resguard  --stacktrace --debug

echo "rename apk"

cd ${buildapk_path}

cp *${product_flavors}.apk /home/quant_group/jenkins/workspace/XyqbAndroidBuild/apk/${branch_name}_${product_flavors}.apk

echo "upload apk to pugongyin"

curl -F "file=@/home/quant_group/jenkins/workspace/XyqbAndroidBuild/apk/${branch_name}_${product_flavors}.apk" -F "uKey=13d17385c02ea9ea994d0c985d87ff32" -F "_api_key=5b09af98d5a8ff43f2f39935fa6bfbc1" https://static.pgyer.com/app/qrcode/lJrv

