project_name=$1
target_dir="/home/quant_group"
holmes='http://holmes.liangkebang.com'
git_path=`curl -s "${holmes}/docker/project/gitPath?project=${project_name}"`


cd ${target_dir}
echo "目录切换到 ${target_dir}"

if [ ! -d "$project_name" ];then
	echo "项目不存在"
	git clone ${git_path}
	cd ${project_name}
else
	echo "项目已存在"
	cd ${project_name}
	echo "cd ${project_name}"
fi

echo "开始部署项目"

if echo "$project_name" | grep	-q -E '\ui$'
then
	echo "这是一个UI项目"
	git pull
	npm install
	npm run build
	echo "重启下nginx"
	/usr/local/openresty/nginx/sbin/nginx -s reload
	echo "done"
else
	echo "这是JAVA项目"
	git pull
	mvn clean package -Ptest -Dmaven.test.skip=true
        echo "supervisorctl restart $project_name"
	supervisorctl restart $project_name
	echo "done"
fi


