const jenkinsApi = require('jenkins-api')

const config = require(global.configPath)

const client = jenkinsApi.init(config.jenkins.api)

const proxy = new Proxy(client, {
  get(target, property) {
    // 只代理函数调用
    if (typeof target[property] === 'function') {
      return function (...args) {
        return new Promise(((resolve, reject) => {
          const cb = function (err, data) {
            if (err) {
              reject(err)
            } else {
              resolve(data)
            }
          }
          args.push(cb)
          client[property](...args)
        }))
      }
    }
  },
})

module.exports = proxy
