const config = require(global.configPath)

module.exports = function () {
  const exclude = [
    '/indexurl/get_index_url',
    '/docker/list_env_vars',
    '/user/login',
    '/user/get_station',
    '/user/check_token',
    '/proconfig/get_info',
    '/proconfig/getK8sConf',
    '/harborHook/endpoint',
    '/k8s/namespace/get_namespace_for_jenkins',
    '/k8s/namespace',
    '/k8s/service/modifyImage',
    '/pipeline/webhooks',
    '/pipeline/dingTalk',
    '/resource/cpu',
    '/resource/memory',
    '/cluster/list',
    '/proconfig/get_project_for_jenkins',
  ]
  return async function (ctx, next) {
    // 从header中获取信息
    const token = ctx.headers['x-token']

    // 查询redis
    const user = await ctx.redisGet(config.QA_TOKEN, token)
    if (process.env.NODE_ENV === 'production' && !user && !exclude.includes(ctx.request.path)) {
      // response.status
      ctx.body = {
        status: 401,
        msg: '未登录',
      }
      return
    }

    ctx.user = user
    await next()
  }
}
