
const { Schema } = require('mongoose')

const schema = new Schema({
  namespace: { type: String },
  active: { type: String, required: true },
  microservice_name: { type: String },
  user: { type: String },
  user_mail: { type: String },
  detail: { type: Object },
  create_time: { type: Date },
}, {
  versionKey: false,
  collection: 'statisticslogs', // 表名
  timestamps: true,
})

schema.statics.saveLog = function (doc) {
  return this.create(doc)
}

const queryHandle = function (query) {
  if (query.namespace !== '') {
    query.namespace = new RegExp(query.namespace)
  } else {
    delete query.namespace
  }

  if (query.active !== '') {
    query.active = new RegExp(query.active)
  } else {
    delete query.active
  }

  if (query.microservice_name !== '') {
    query.microservice_name = new RegExp(query.microservice_name)
  } else {
    delete query.microservice_name
  }

  return query
}

schema.statics.getLog = function (query, sort, num, count) {
  query = queryHandle(query)
  return this.find(query).sort(sort).skip(num * count).limit(count)
}

schema.statics.getLogCount = function (query) {
  query = queryHandle(query)
  return this.find(query).countDocuments()
}

module.exports = schema
