
const Schema = require('mongoose').Schema

const schema = new Schema({
  name: {
    type: String, unique: true, required: true, index: true,
  },
  base: { type: Array },
  ui: { type: Array },
  java: { type: Array },
  node: { type: Array },
  python: { type: Array },
}, {
  versionKey: false,
  collection: 'envtemplates', // 表名
  timestamps: true,
})

schema.statics.getTemplates = function (query, column, sort) {
  return this.find(query, column).sort(sort)
}

schema.statics.getByName = function (name) {
  return this.findOne({ name })
}

schema.statics.save = async function (doc) {
  if (doc._id) {
    delete doc.updatedAt
    return this.update({
      _id: doc._id,
    }, doc)
  }
  return this.create(doc)
}

schema.statics.delete = function (id) {
  return this.findByIdAndRemove(id)
}

module.exports = schema
