const schedule = require('node-schedule')
const logger = require('koa-log4').getLogger('jobs:syncDBMQ')
// const sleep = require('sleep')
const jenkinsService = require('../service/jenkinsService')
const k8sService = require('../service/k8sService')
const mqService = require('../service/mqService')

const dbname = 'all(no_mall)'
const keepBusinessData = true
const useCache = true

const job = schedule.scheduleJob('0 2 * * 6', async () => {
  try {
    const ns = await k8sService.listEnv()
    const MQDefinition = await mqService.getDefinitions()

    for (const i of ns) {
      const env = await k8sService.listEnvVars(i.name)

      if (env.DB_SERVICE_HOST) {
        logger.info(`开始同步DB：${i.name}`)
        const res = await jenkinsService.build_with_params('sync_database_schema', {
          depth: 1,
          sync_db_name: dbname,
          target_db_host: env.DB_SERVICE_HOST,
          target_db_port: env.DB_SERVICE_PORT,
          re_replace_ip: i.name,
          not_delete_business_data: keepBusinessData,
          use_cache: useCache,
        })
        logger.info(`${i.name}的同步队列：${res.location}`)
        // sleep.sleep(60)
      }

      if (env.RABBITMQ_SERVICE_HOST) {
        logger.info(`开始同步MQ：${i.name}`)
        await mqService.setDefinitions(`${env.RABBITMQ_SERVICE_HOST}:${env.RABBITMQ_SERVICE_PORT}`, MQDefinition)
        logger.info(`${i.name}同步MQ完成`)
      }
    }
  } catch (e) {
    logger.error('syncDBMQ', e)
  }
})

module.exports = job
