const log = require('koa-log4').getLogger('service:pipelines')
const Router = require('koa-router')
const moment = require('moment')
const bodyParser = require('koa-bodyparser')
const request = require('request')
const sleep = require('../utils/sleep')
const config = require('../../src');
const { PipeLine, PipeLinePush } = require('../service/mongoService')
const jenkinsService = require('../service/jenkinsService')
const dingTalk = require('../utils/dingTalk')

const awaitRequest = function (options) {
  return new Promise((resolve, reject) => {
    request(options, (error, res, body) => {
      if (error) {
        reject(error)
      } else {
        resolve(body)
      }
    })
  })
}
const webhooks = async function (ctx) {
  const projectName = ctx.request.body.repository.name
  const arr = ctx.request.body.ref.split('/')
  const branchName = arr[arr.length - 1]
  const gitUser = ctx.request.body.user_name
  const objectKind = ctx.request.body.object_kind
  const commitMes = ctx.request.body.commits[0].message
  const timestamp = ctx.request.body.commits[0].timestamp
  const data = await PipeLine.getOnePipe(projectName)
  const task = []
  // order 缓存数据 方便以后找到对应的钉钉地址
  const order = []
  data.forEach(async (item, index) => {
    await sleep(3)
    let images = {}
    item.repos.forEach((value) => {
      if (value.repository === projectName && value.ref.name === branchName) {
        images = value
        order.push(index)
      }
    })
    log.info('拿到的子数据为:', images);
    const result = jenkinsService.build_with_params(`tke-${images.type}`, {
      depth: 1,
      GIT_REPO: `${images.groupName}/${projectName}`,
      BRANCH_NAME: images.ref.name,
      NAMESPACE: item.namespace,
      IS_DEPLOY: item.isDeploy,
      CLUSTER: 'test',
      IMAGE_REPOSITORY: `ccr.ccs.tencentyun.com/qa-${images.type}`,
    })
    task.push(result)
  })
  const finalData = await Promise.all(task)
  let index = 0
  finalData.forEach(async (item) => {
    let flag = true
    while (flag) {
      const apiJson = await jenkinsService.queue_item(item.queueId);
      if (apiJson.executable) {
        index += 1
        flag = false
        let type = null
        data[order[index - 1]].repos.forEach((value) => {
          if (value.repository === projectName) {
            type = value.type
          }
        })
        const store = {
          namespace: data[order[index - 1]].namespace,
          buildId: apiJson.executable.number,
          branchName,
          commitMes,
          projectName,
          applicationName: data[order[index - 1]].application_name,
          gitUser,
          noticeAddress: data[order[index - 1]].noticeAddress,
          gitEventTime: timestamp,
          objectKind,
          type,
        }
        const result = await PipeLinePush.getOnePipePush(apiJson.executable.number)
        if (result.length === 0) {
          await PipeLinePush.savePipesPush(store)
        }
      }
    }
  })
  ctx.body = ctx.ok(finalData)
}

const getMaster = async function (ctx) {
  const { name, gitlabAddress } = ctx.request.body
  let projectId
  const data = await awaitRequest({
    url: `http://${gitlabAddress}/api/v4/projects?per_page=200&search=${name}&private_token=${config.gitlab.token}`,
    method: 'GET',
  })
  if (JSON.parse(data).length === 0) {
    ctx.body = ctx.fail('无拉去此项目的权限')
    return
  }
  JSON.parse(data).forEach((item) => {
    // 再次筛选下数据 因为gitlab返回的数据是模糊查询
    if (item.name === name) {
      projectId = item.id
    }
  })
  const dataMaster = await awaitRequest({
    url: `http://${gitlabAddress}/api/v4/projects/${projectId}/repository/branches?private_token=${config.gitlab.token}`,
    method: 'GET',
  })
  ctx.body = ctx.ok(JSON.parse(dataMaster))
}
const findPipes = async function (ctx) {
  const data = await PipeLine.getPipes(ctx.request.body)
  ctx.body = ctx.ok(data)
}
const save = async function (ctx) {
  const data = ctx.request.body
  await PipeLine.savePipes(data)
  ctx.body = ctx.ok('ok')
}
const deletePipes = async function (ctx) {
  const id = ctx.request.body.id
  const res = await PipeLine.delete(id)
  ctx.body = ctx.ok(res)
}
const dingTalkPush = async function (ctx) {
  const { buildNumber, flag } = ctx.request.body
  const result = await PipeLinePush.getOnePipePush(buildNumber)
  if (result.length === 0) {
    ctx.body = ctx.fail('未查到结果集，不发送钉钉推送消息')
    return
  }
  const url = 'http://172.29.1.15:8080/view/TKE/job/tke-'
  result.forEach(async (item) => {
    const text = `> 项目名称 : ${item.projectName}\n\n`
      + `> 分支名称 : ${item.branchName}\n\n`
      + `> 部署空间 : ${item.namespace}\n\n`
      + `> 触发同学 : ${item.gitUser}\n\n`
      + `> 触发时间 : ${moment().format('YYYY-MM-DD HH:mm:ss')}\n\n`
      + `> 提交信息 : ${item.commitMes}\n\n`
      + `#### 结果 : ${flag === 'success' ? '成功' : '失败'}   [查看详情](${url}${item.type}/${item.buildId}/)`
    const title = '流水线信息如下'
    await dingTalk(title, text, item.noticeAddress)
  })

  ctx.body = ctx.ok(200)
}
const router = new Router()
router
  .use(bodyParser())
  .post('/save', save)
  .post('/master', getMaster)
  .post('/find', findPipes)
  .post('/webhooks', webhooks)
  .post('/delete', deletePipes)
  .post('/dingTalk', dingTalkPush)
module.exports = router
