const Router = require('koa-router')
const { CpuResource, MemoryResource } = require('../service/mongoService')

const router = new Router()
module.exports = router

const formatData = (list) => {
  const data = list.reduce((a, b) => {
    b.name = b.name.split('-').slice(0, -2).join('-')
    if (!a[b.name]) {
      a[b.name] = b
    }
    if (a[b.name].Percentage < b.Percentage) {
      a[b.name] = b
    }
    return a
  }, {})

  const res = []
  // eslint-disable-next-line guard-for-in
  for (const i in data) {
    res.push(data[i])
  }

  res.sort((a, b) => (a.Percentage - b.Percentage))
  return res
}

const handleQuery = obj => ({
  name: obj.name,
  createdAt: {
    $gte: new Date(new Date(obj.startTime).toISOString()),
    $lt: new Date(new Date(obj.endTime).toISOString()),
  },
})

const getCpu = async (ctx) => {
  const query = handleQuery(ctx.request.query)
  const list = await CpuResource.getCpu2(query, { _id: 0 })
  const res = formatData(list)
  ctx.body = ctx.ok(res)
}

const getCpuInfo = async (ctx) => {
  const query = handleQuery(ctx.request.query)
  let list = await CpuResource.getCpu2(query, { _id: 0 }, { Percentage: 1 })
  list = list.filter(i => i.name.split('-').length - 2 === ctx.request.query.name.split('-').length)
  ctx.body = ctx.ok(list)
}

const getMemory = async (ctx) => {
  const query = handleQuery(ctx.request.query)
  const list = await MemoryResource.getMemory2(query, { _id: 0 })
  const res = formatData(list)
  ctx.body = ctx.ok(res)
}

const getMemoryInfo = async (ctx) => {
  const query = handleQuery(ctx.request.query)
  let list = await MemoryResource.getMemory2(query, { _id: 0 }, { Percentage: 1 })
  list = list.filter(i => i.name.split('-').length - 2 === ctx.request.query.name.split('-').length)
  ctx.body = ctx.ok(list)
}

router
  .get('/cpu', getCpu)
  .get('/cpuInfo', getCpuInfo)
  .get('/memory', getMemory)
  .get('/memoryInfo', getMemoryInfo)
