const Router = require('koa-router')
const bodyParser = require('koa-bodyparser');

const { Cluster } = require('../service/mongoService')

const router = new Router()
module.exports = router
const getCluster = async (ctx) => {
  const res = await Cluster.getCluster({ clusterName: ctx.request.query.clusterName })
  ctx.body = ctx.ok(res)
}

const addCluster = async (ctx) => {
  const res = await Cluster.saveCluster(ctx.request.body)
  ctx.body = ctx.ok(res)
}
const deleteCluster = async (ctx) => {
  const res = await Cluster.deleteCluster(ctx.request.query.id)
  ctx.body = ctx.ok(res)
}


router
  .get('/list', getCluster)
  .post('/add', bodyParser(), addCluster)
  .get('/delete', deleteCluster)
