const schedule = require('node-schedule')
const logger = require('koa-log4').getLogger('jobs:calculation cpu')
const moment = require('moment')
const { CpuResource } = require('../service/mongoService')
const awaitRequest = require('../utils/awaitRequest')

const config = require(global.configPath)

async function job() {
  logger.info('cpu rate job start')
  const endTime = Math.round(moment().valueOf() / 1000)
  const startTime = endTime - (60 * 60 * 12)
  const finalCpuLimit = {}
  let url = `${config.prometheus}/api/v1/query?query=sum%20(container_spec_cpu_quota%20
      {namespace!~%22kube-system|monitor|rc-test%22}/(100*1000))%20by%20(pod_name)`
  const cpuLimitRes = await awaitRequest({
    url,
    method: 'GET',
  })
  logger.info('container_spec_cpu_quota_log', cpuLimitRes.status, cpuLimitRes.data.result.length, url)

  cpuLimitRes.data.result.forEach((item) => {
    if (item.metric.pod_name) {
      finalCpuLimit[item.metric.pod_name] = item.value[1]
    }
  })

  const finalCpuUsage = {}
  let flag = 0
  url = `${config.prometheus}/api/v1/query_range?query=sum (rate (container_cpu_usage_seconds_total
    {image!="",name=~"^k8s_.*",io_kubernetes_container_name!="POD",pod_name=~"^()()().*$"}[1m])) by
     (pod_name)&start=${startTime}&end=${endTime}&step=60`
  let cpuUsageRes = { data: { result: [] } }
  while (cpuUsageRes.data.result.length === 0 && flag < 10) {
    cpuUsageRes = await awaitRequest({
      url,
      method: 'GET',
    })
    logger.info('container_cpu_usage_seconds_total_log', cpuUsageRes.status, cpuUsageRes.data.result.length, url)
    flag += 1
  }

  cpuUsageRes.data.result.forEach((item) => {
    if (item.metric.pod_name) {
      finalCpuUsage[item.metric.pod_name] = parseFloat(item.values[0][1])
      item.values.forEach((i) => {
        const cpuUsage = parseFloat(i[1])
        if (cpuUsage > finalCpuUsage[item.metric.pod_name]) {
          finalCpuUsage[item.metric.pod_name] = cpuUsage
        }
      })
    }
  })

  Object.keys(finalCpuLimit).forEach((item) => {
    const data = {
      name: item,
      cpuLimit: finalCpuLimit[item],
      cpuMaxUsage: finalCpuUsage[item],
      Percentage: `${(finalCpuUsage[item] / finalCpuLimit[item]).toFixed(4)}`,
    }
    CpuResource.saveCpu(data)
  })

  const dingdingMessage = {
    msgtype: 'link',
    link: {
      title: 'cpu统计已同步更新到qa-home下的resource目录，点击可查看详情',
      text: `cpu统计告知:${moment().format('YYYY-MM-DD HH:mm:ss')}`,
      messageUrl: `${config.qahomeHost}/resources/cpu`,
    },
  }
  await awaitRequest({
    url: config.dingdingResouce,
    method: 'POST',
    headers: {
      'Content-Type': 'application/json;charset=utf-8',
    },
    body: JSON.stringify(dingdingMessage),
  })
  logger.info('cpu rate job end')
}
// module.exports = schedule.scheduleJob('*/2 * * * ?', async () => {
module.exports = schedule.scheduleJob('30 0 20 * * ?', async () => {
  try {
    job()
  } catch (e) {
    logger.info('calculation cpu', e)
  }
})
