

const _ = require('lodash')
const Router = require('koa-router')
const queryString = require('querystring')
const uuid = require('uuid')
const logger = require('koa-log4').getLogger('router:user')

const config = require(global.configPath)
const bodyParser = require('koa-bodyparser')
const authenticate = require('../service/authenticate')


const router = new Router()
const admin = ['qiaoling.yu', 'zhijie.xue', 'luoyong.meng', 'qiuyue.gui', 'bo.li', 'haiyuan.wen', 'jinsong.zhu']


const login = async function (ctx) {
  const { body } = ctx.request

  try {
    let query = queryString.unescape(body.auth)
    query = Buffer.from(query, 'base64').toString()
    query = query.replace(' ', '+')
    // body = queryString.parse(query)
    const userinfo = query.match((/^user\=([\w@\.]+)&password=(.+)/))

    if (!(userinfo[1] && userinfo[2])) {
      ctx.body = ctx.fail('用户名或密码未填写')
      return
    }

    // 认证
    const user = await authenticate.ldap(userinfo[1].substring(0, userinfo[1].indexOf('@')), userinfo[2])

    if (!user) {
      ctx.body = ctx.fail('用户名或密码错误')
      return
    }

    const token = uuid.v4()
    ctx.redisSet(config.QA_TOKEN, token, _.cloneDeep(user))
    user.token = token
    ctx.body = ctx.ok({ msg: '登录成功', token })
  } catch (e) {
    logger.error(e)
    ctx.body = ctx.fail(`登录失败: ${e}`)
  }
}

const checkToken = async (ctx) => {
  const { token } = ctx.request.query
  const info = await ctx.redisGet(config.QA_TOKEN, token)
  if (info) {
    ctx.body = {
      code: '0000',
      name: info.cn,
      title: info.title,
      user: info.SAMACCOUNTNAME,
      mail: info.mail,
    }
    return
  }
  ctx.body = ctx.fail('check_token 失败')
}

const checkTokenNew = async (ctx) => {
  const { token } = ctx.request.query
  const info = await ctx.redisGet(config.QA_TOKEN, token)
  if (info) {
    const role = admin.includes(info.SAMACCOUNTNAME || info.sAMAccountName) ? ['admin'] : ['user']

    if (info.title && info.title.indexOf('测试') !== -1) {
      role.push('test')
    } else {
      role.push('dev')
    }

    ctx.body = {
      code: '0000',
      data: {
        name: info.cn,
        title: info.title,
        user: info.SAMACCOUNTNAME,
        mail: info.mail,
        role,
      },
    }
    return
  }
  ctx.body = ctx.fail('check_token 失败')
}

const getStation = async (ctx) => {
  const re = [{
    label: 'qahome',
    url: config.QaHome,
  }, {
    label: 'blackpreal',
    url: config.BlackPreal,
  }, {
    label: 'cicd',
    url: config.CiCD,
  }]
  ctx.body = re
}

router
  .get('/check_token', checkToken)
  .get('/check_token_new', checkTokenNew)
  .post('/login', bodyParser(), login)
  .get('/get_station', getStation)

module.exports = router
