
const Router = require('koa-router')
const bodyParser = require('koa-bodyparser')

const Log = require('../service/mongoService').StatisticsLog

const getLog = async function (ctx) {
  const data = {
    namespace: ctx.request.body.query.namespace,
    active: ctx.request.body.query.active,
    microservice_name: ctx.request.body.query.microservice_name,
  }
  if (ctx.request.body.query.user) {
    data.user = ctx.request.body.query.user
  }
  const item = await Log.getLog(data, {
    createdAt: -1,

  }, ctx.request.body.query.num, ctx.request.body.query.count)

  ctx.body = ctx.ok(item)
}

const getLogCount = async function (ctx) {
  const data = {
    namespace: ctx.request.body.query.namespace,
    active: ctx.request.body.query.active,
    microservice_name: ctx.request.body.query.microservice_name,
  }
  if (ctx.request.body.query.user) {
    data.user = ctx.request.body.query.user
  }
  const item = await Log.getLogCount(data)

  ctx.body = ctx.ok(item)
}

const router = new Router()
router
  .use(bodyParser())
  .post('/get_log_count', getLogCount)
  .post('/get_log', getLog)

module.exports = router
