

const _ = require('lodash')
const Router = require('koa-router')
const bodyParser = require('koa-bodyparser')
const { IndexUrl } = require('../service/mongoService')

const getIndexUrl = async (ctx) => {
  const data = ctx.request.query
  let item = await IndexUrl.getIndexUrl(data)
  item = _.groupBy(item, 'type_name')
  const arr = []
  const classes = ['primary', 'danger', 'success', 'info', 'warning', 'accent']
  let index = 0
  for (const key in item) {
    if (Object.prototype.hasOwnProperty.call(item, key)) {
      arr.push({
        name: key,
        type: item[key][0].type,
        data: item[key],
        class: classes[index],
      })
      index += 1
    }
  }
  ctx.body = ctx.ok(arr)
}

const save = async (ctx) => {
  const data = ctx.request.body
  const rule = {
    url: 'required',
    type_name: 'required',
    remark: 'required',
  }
  if (!ctx.validate(data, rule)) {
    ctx.body = ctx.fail(ctx.Code.ERROR_INPUT)
    return
  }

  if (data.url.indexOf('http')) {
    ctx.body = ctx.fail('url地址中须包括http://')
    return
  }

  data.type = await IndexUrl.getType(data.type_name)

  await IndexUrl.save(data)
  ctx.body = ctx.ok()
}

const remove = async (ctx) => {
  const data = ctx.request.query
  const rule = {
    _id: 'required',
  }
  if (!ctx.validate(data, rule)) {
    ctx.body = ctx.fail(ctx.Code.ERROR_INPUT)
    return
  }
  const item = await IndexUrl.delete(data._id)
  ctx.body = ctx.ok(item)
}

const router = new Router()
router
  .get('/get_index_url', getIndexUrl)
  .post('/save', bodyParser(), save)
  .get('/delete', remove)

module.exports = router
