
const { Schema } = require('mongoose')


// 表结构
const schema = new Schema({
  name: { type: String },
  memoryLimit: { type: Number },
  memoryMaxUsage: { type: Number },
  Percentage: { type: Number },
}, {
  versionKey: false,
  collection: 'memoryResource', // 表名
  timestamps: true,
})
schema.statics.saveMemory = function (doc) {
  return this.create(doc)
}
schema.statics.updateMemory = function (doc) {
  return this.update(doc)
}
schema.statics.getMemory = function (start, end) {
  return this.aggregate([
    {
      $match: {
        createdAt: { $gte: new Date(new Date(start).toISOString()), $lt: new Date(new Date(end).toISOString()) },
      },
    },
    {
      $group: {
        _id: '$name',
        memoryLimit: { $max: '$memoryLimit' },
        memoryMaxUsage: { $max: '$memoryMaxUsage' },
        Percentage: { $max: '$Percentage' },
      },
    }, {
      $sort: {
        Percentage: 1,
      },
    }])
}

schema.statics.getMemory2 = function (query, column, sort) {
  if (query.name) {
    query.name = new RegExp(query.name)
  } else {
    delete query.name
  }
  return this.find(query, column).sort(sort).lean()
}

module.exports = schema
